% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_create_elasticsearch_domain}
\alias{elasticsearchservice_create_elasticsearch_domain}
\title{Creates a new Elasticsearch domain}
\usage{
elasticsearchservice_create_elasticsearch_domain(
  DomainName,
  ElasticsearchVersion = NULL,
  ElasticsearchClusterConfig = NULL,
  EBSOptions = NULL,
  AccessPolicies = NULL,
  SnapshotOptions = NULL,
  VPCOptions = NULL,
  CognitoOptions = NULL,
  EncryptionAtRestOptions = NULL,
  NodeToNodeEncryptionOptions = NULL,
  AdvancedOptions = NULL,
  LogPublishingOptions = NULL,
  DomainEndpointOptions = NULL,
  AdvancedSecurityOptions = NULL,
  AutoTuneOptions = NULL,
  TagList = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the Elasticsearch domain that you are creating. Domain names
are unique across the domains owned by an account within an AWS region.
Domain names must start with a lowercase letter and can contain the
following characters: a-z (lowercase), 0-9, and - (hyphen).}

\item{ElasticsearchVersion}{String of format X.Y to specify version for the Elasticsearch domain eg.
"1.5" or "2.3". For more information, see <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#es-createdomains"
target="_blank">Creating Elasticsearch Domains</a> in the \emph{Amazon
Elasticsearch Service Developer Guide}.}

\item{ElasticsearchClusterConfig}{Configuration options for an Elasticsearch domain. Specifies the
instance type and number of instances in the domain cluster.}

\item{EBSOptions}{Options to enable, disable and specify the type and size of EBS storage
volumes.}

\item{AccessPolicies}{IAM access policy as a JSON-formatted string.}

\item{SnapshotOptions}{Option to set time, in UTC format, of the daily automated snapshot.
Default value is 0 hours.}

\item{VPCOptions}{Options to specify the subnets and security groups for VPC endpoint. For
more information, see <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html#es-creating-vpc"
target="_blank">Creating a VPC</a> in \emph{VPC Endpoints for Amazon
Elasticsearch Service Domains}}

\item{CognitoOptions}{Options to specify the Cognito user and identity pools for Kibana
authentication. For more information, see <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
target="_blank">Amazon Cognito Authentication for Kibana</a>.}

\item{EncryptionAtRestOptions}{Specifies the Encryption At Rest Options.}

\item{NodeToNodeEncryptionOptions}{Specifies the NodeToNodeEncryptionOptions.}

\item{AdvancedOptions}{Option to allow references to indices in an HTTP request body. Must be
\code{false} when configuring access to individual sub-resources. By default,
the value is \code{true}. See <a
href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#es-createdomain-configure-advanced-options"
target="_blank">Configuration Advanced Options</a> for more information.}

\item{LogPublishingOptions}{Map of \code{LogType} and \code{LogPublishingOption}, each containing options to
publish a given type of Elasticsearch log.}

\item{DomainEndpointOptions}{Options to specify configuration that will be applied to the domain
endpoint.}

\item{AdvancedSecurityOptions}{Specifies advanced security options.}

\item{AutoTuneOptions}{Specifies Auto-Tune options.}

\item{TagList}{A list of \code{Tag} added during domain creation.}
}
\description{
Creates a new Elasticsearch domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the \emph{Amazon Elasticsearch Service Developer Guide}.

See \url{https://paws-r.github.io/docs/elasticsearchservice/create_elasticsearch_domain.html} for full documentation.
}
\keyword{internal}
