% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_associate_qualification_with_worker}
\alias{mturk_associate_qualification_with_worker}
\title{The AssociateQualificationWithWorker operation gives a Worker a
Qualification}
\usage{
mturk_associate_qualification_with_worker(QualificationTypeId, WorkerId,
  IntegerValue, SendNotification)
}
\arguments{
\item{QualificationTypeId}{[required] The ID of the Qualification type to use for the assigned Qualification.}

\item{WorkerId}{[required] The ID of the Worker to whom the Qualification is being assigned. Worker
IDs are included with submitted HIT assignments and Qualification
requests.}

\item{IntegerValue}{The value of the Qualification to assign.}

\item{SendNotification}{Specifies whether to send a notification email message to the Worker
saying that the qualification was assigned to the Worker. Note: this is
true by default.}
}
\description{
The \code{AssociateQualificationWithWorker} operation gives a Worker a
Qualification. \code{AssociateQualificationWithWorker} does not require that
the Worker submit a Qualification request. It gives the Qualification
directly to the Worker.
}
\details{
You can only assign a Qualification of a Qualification type that you
created (using the \code{CreateQualificationType} operation).

Note: \code{AssociateQualificationWithWorker} does not affect any pending
Qualification requests for the Qualification by the Worker. If you
assign a Qualification to a Worker, then later grant a Qualification
request made by the Worker, the granting of the request may modify the
Qualification score. To resolve a pending Qualification request without
affecting the Qualification the Worker already has, reject the request
with the \code{RejectQualificationRequest} operation.
}
\section{Request syntax}{
\preformatted{svc$associate_qualification_with_worker(
  QualificationTypeId = "string",
  WorkerId = "string",
  IntegerValue = 123,
  SendNotification = TRUE|FALSE
)
}
}

\keyword{internal}
