% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_search_dashboards}
\alias{quicksight_search_dashboards}
\title{Searches for dashboards that belong to a user}
\usage{
quicksight_search_dashboards(AwsAccountId, Filters, NextToken,
  MaxResults)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the user whose dashboards you're
searching for.}

\item{Filters}{[required] The filters to apply to the search. Currently, you can search only by
user name, for example,
\verb{"Filters": [ \{ "Name": "QUICKSIGHT_USER", "Operator": "StringEquals", "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1" \} ]}}

\item{NextToken}{The token for the next set of results, or null if there are no more
results.}

\item{MaxResults}{The maximum number of results to be returned per request.}
}
\value{
A list with the following syntax:\preformatted{list(
  DashboardSummaryList = list(
    list(
      Arn = "string",
      DashboardId = "string",
      Name = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      LastUpdatedTime = as.POSIXct(
        "2015-01-01"
      ),
      PublishedVersionNumber = 123,
      LastPublishedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string",
  Status = 123,
  RequestId = "string"
)
}
}
\description{
Searches for dashboards that belong to a user.
}
\section{Request syntax}{
\preformatted{svc$search_dashboards(
  AwsAccountId = "string",
  Filters = list(
    list(
      Operator = "StringEquals",
      Name = "QUICKSIGHT_USER",
      Value = "string"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
