% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_list_steps}
\alias{emr_list_steps}
\title{Provides a list of steps for the cluster in reverse order unless you
specify stepIds with the request of filter by StepStates}
\usage{
emr_list_steps(ClusterId, StepStates, StepIds, Marker)
}
\arguments{
\item{ClusterId}{[required] The identifier of the cluster for which to list the steps.}

\item{StepStates}{The filter to limit the step list based on certain states.}

\item{StepIds}{The filter to limit the step list based on the identifier of the steps.
You can specify a maximum of ten Step IDs. The character constraint
applies to the overall length of the array.}

\item{Marker}{The pagination token that indicates the next set of results to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Steps = list(
    list(
      Id = "string",
      Name = "string",
      Config = list(
        Jar = "string",
        Properties = list(
          "string"
        ),
        MainClass = "string",
        Args = list(
          "string"
        )
      ),
      ActionOnFailure = "TERMINATE_JOB_FLOW"|"TERMINATE_CLUSTER"|"CANCEL_AND_WAIT"|"CONTINUE",
      Status = list(
        State = "PENDING"|"CANCEL_PENDING"|"RUNNING"|"COMPLETED"|"CANCELLED"|"FAILED"|"INTERRUPTED",
        StateChangeReason = list(
          Code = "NONE",
          Message = "string"
        ),
        FailureDetails = list(
          Reason = "string",
          Message = "string",
          LogFile = "string"
        ),
        Timeline = list(
          CreationDateTime = as.POSIXct(
            "2015-01-01"
          ),
          StartDateTime = as.POSIXct(
            "2015-01-01"
          ),
          EndDateTime = as.POSIXct(
            "2015-01-01"
          )
        )
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Provides a list of steps for the cluster in reverse order unless you
specify \code{stepIds} with the request of filter by \code{StepStates}. You can
specify a maximum of ten \code{stepIDs}.
}
\section{Request syntax}{
\preformatted{svc$list_steps(
  ClusterId = "string",
  StepStates = list(
    "PENDING"|"CANCEL_PENDING"|"RUNNING"|"COMPLETED"|"CANCELLED"|"FAILED"|"INTERRUPTED"
  ),
  StepIds = list(
    "string"
  ),
  Marker = "string"
)
}
}

\keyword{internal}
