% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_list_domains_for_package}
\alias{elasticsearchservice_list_domains_for_package}
\title{Lists all Amazon ES domains associated with the package}
\usage{
elasticsearchservice_list_domains_for_package(PackageID, MaxResults,
  NextToken)
}
\arguments{
\item{PackageID}{[required] The package for which to list domains.}

\item{MaxResults}{Limits results to a maximum number of domains.}

\item{NextToken}{Used for pagination. Only necessary if a previous API call includes a
non-null NextToken value. If provided, returns results for the next
page.}
}
\value{
A list with the following syntax:\preformatted{list(
  DomainPackageDetailsList = list(
    list(
      PackageID = "string",
      PackageName = "string",
      PackageType = "TXT-DICTIONARY",
      LastUpdated = as.POSIXct(
        "2015-01-01"
      ),
      DomainName = "string",
      DomainPackageStatus = "ASSOCIATING"|"ASSOCIATION_FAILED"|"ACTIVE"|"DISSOCIATING"|"DISSOCIATION_FAILED",
      PackageVersion = "string",
      ReferencePath = "string",
      ErrorDetails = list(
        ErrorType = "string",
        ErrorMessage = "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists all Amazon ES domains associated with the package.
}
\section{Request syntax}{
\preformatted{svc$list_domains_for_package(
  PackageID = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
