% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_cancel_ml_task_run}
\alias{glue_cancel_ml_task_run}
\title{Cancels (stops) a task run}
\usage{
glue_cancel_ml_task_run(TransformId, TaskRunId)
}
\arguments{
\item{TransformId}{[required] The unique identifier of the machine learning transform.}

\item{TaskRunId}{[required] A unique identifier for the task run.}
}
\value{
A list with the following syntax:\preformatted{list(
  TransformId = "string",
  TaskRunId = "string",
  Status = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT"
)
}
}
\description{
Cancels (stops) a task run. Machine learning task runs are asynchronous
tasks that AWS Glue runs on your behalf as part of various machine
learning workflows. You can cancel a machine learning task run at any
time by calling \code{\link[=glue_cancel_ml_task_run]{cancel_ml_task_run}} with a
task run's parent transform's \code{TransformID} and the task run's
\code{TaskRunId}.
}
\section{Request syntax}{
\preformatted{svc$cancel_ml_task_run(
  TransformId = "string",
  TaskRunId = "string"
)
}
}

\keyword{internal}
