% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_describe_inbound_cross_cluster_search_connections}
\alias{elasticsearchservice_describe_inbound_cross_cluster_search_connections}
\title{Lists all the inbound cross-cluster search connections for a destination
domain}
\usage{
elasticsearchservice_describe_inbound_cross_cluster_search_connections(
  Filters, MaxResults, NextToken)
}
\arguments{
\item{Filters}{A list of filters used to match properties for inbound cross-cluster
search connection. Available \code{Filter} names for this operation are:
\itemize{
\item cross-cluster-search-connection-id
\item source-domain-info.domain-name
\item source-domain-info.owner-id
\item source-domain-info.region
\item destination-domain-info.domain-name
}}

\item{MaxResults}{Set this value to limit the number of results returned. If not
specified, defaults to 100.}

\item{NextToken}{NextToken is sent in case the earlier API call results contain the
NextToken. It is used for pagination.}
}
\value{
A list with the following syntax:\preformatted{list(
  CrossClusterSearchConnections = list(
    list(
      SourceDomainInfo = list(
        OwnerId = "string",
        DomainName = "string",
        Region = "string"
      ),
      DestinationDomainInfo = list(
        OwnerId = "string",
        DomainName = "string",
        Region = "string"
      ),
      CrossClusterSearchConnectionId = "string",
      ConnectionStatus = list(
        StatusCode = "PENDING_ACCEPTANCE"|"APPROVED"|"REJECTING"|"REJECTED"|"DELETING"|"DELETED",
        Message = "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists all the inbound cross-cluster search connections for a destination
domain.
}
\section{Request syntax}{
\preformatted{svc$describe_inbound_cross_cluster_search_connections(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
