% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_set_task_status}
\alias{datapipeline_set_task_status}
\title{Task runners call SetTaskStatus to notify AWS Data Pipeline that a task
is completed and provide information about the final status}
\usage{
datapipeline_set_task_status(taskId, taskStatus, errorId, errorMessage,
  errorStackTrace)
}
\arguments{
\item{taskId}{[required] The ID of the task assigned to the task runner. This value is provided
in the response for \code{\link[=datapipeline_poll_for_task]{poll_for_task}}.}

\item{taskStatus}{[required] If \code{FINISHED}, the task successfully completed. If \code{FAILED}, the task
ended unsuccessfully. Preconditions use false.}

\item{errorId}{If an error occurred during the task, this value specifies the error
code. This value is set on the physical attempt object. It is used to
display error information to the user. It should not start with string
"Service_" which is reserved by the system.}

\item{errorMessage}{If an error occurred during the task, this value specifies a text
description of the error. This value is set on the physical attempt
object. It is used to display error information to the user. The web
service does not parse this value.}

\item{errorStackTrace}{If an error occurred during the task, this value specifies the stack
trace associated with the error. This value is set on the physical
attempt object. It is used to display error information to the user. The
web service does not parse this value.}
}
\value{
An empty list.
}
\description{
Task runners call \code{\link[=datapipeline_set_task_status]{set_task_status}} to
notify AWS Data Pipeline that a task is completed and provide
information about the final status. A task runner makes this call
regardless of whether the task was sucessful. A task runner does not
need to call \code{\link[=datapipeline_set_task_status]{set_task_status}} for tasks
that are canceled by the web service during a call to
\code{\link[=datapipeline_report_task_progress]{report_task_progress}}.
}
\section{Request syntax}{
\preformatted{svc$set_task_status(
  taskId = "string",
  taskStatus = "FINISHED"|"FAILED"|"FALSE",
  errorId = "string",
  errorMessage = "string",
  errorStackTrace = "string"
)
}
}

\keyword{internal}
