% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie.R
\name{cie}
\alias{cie}
\title{CIE colour spaces}
\usage{
cie(
  vismodeldata,
  space = c("XYZ", "LAB", "LCh"),
  visual = c("cie2", "cie10"),
  illum = c("D65", "bluesky", "forestshade")
)
}
\arguments{
\item{vismodeldata}{(required) quantum catch color data. Can be either the result
from \code{\link[=vismodel]{vismodel()}} or independently calculated data (in the form of a
data frame with three columns representing trichromatic viewer).}

\item{space}{(required) Choice between XYZ (default), LAB, or LCh colour models.}

\item{visual}{the visual system used when estimating XYZ values, if \code{vismodeldata} are
not the result of a call to \code{vismodel()} (otherwise the argument is ignored). Options are:
\itemize{
\item a data frame such as one produced containing by \code{\link[=sensmodel]{sensmodel()}}, containing
user-defined sensitivity data for the receptors involved in colour vision.
The data frame must contain a \code{'wl'} column with the range of wavelengths included,
and the sensitivity for each other cone as a column.
\item \code{'cie2'}: 2-degree colour matching functions for CIE models of human
colour vision. Functions are linear transformations of the 2-degree cone fundamentals
of Stockman & Sharpe (2000), as ratified by the CIE (2006).
\item \code{'cie10'}: 10-degree colour matching functions for CIE models of human
colour vision. Functions are linear transformations of the 10-degree cone fundamentals
of Stockman & Sharpe (2000), as ratified by the CIE (2006).
}}

\item{illum}{the illuminant used when estimating XYZ values, if \code{vismodeldata} are
not the result of a call to \code{vismodel()} (otherwise the argument is ignored).
Either a data frame containing a \code{'wl'} column and the illuminant spectrum, or
one of the built-in options:
\itemize{
\item \code{'D65'}: standard daylight.
\item \code{'bluesky'} open blue sky.
\item \code{'forestshade'} forest shade.
}}
}
\value{
Object of class \code{\link{colspace}} containing:
\itemize{
\item \verb{X, Y, Z}: Tristimulus values.
\item \verb{x, y, z}: Cartesian coordinates, when using \code{space = XYZ}.
\item \verb{L, a, b}: Lightness, \code{L}, and colour-opponent \code{a} (redness-greenness) and
\code{b} (yellowness-blueness) values, in a Cartesian coordinate space. Returned
when using \code{space = LAB}.
\item \verb{L, a, b, C, h}: Lightness, \code{L}, colour-opponent \code{a} (redness-greenness)
and \code{b} (yellowness-blueness) values, as well as chroma \code{C} and hue-angle \code{h}
(degrees), the latter of which are cylindrical representations of \code{a} and \code{b}
from the CIELAB model. Returned when using \code{space = LCh}.
}
}
\description{
Calculates coordinates and colorimetric variables that represent reflectance spectra
in either the CIEXYZ (1931), CIELAB (1971), or CIELCh (1971) colourspaces.
}
\examples{
data(flowers)
vis.flowers <- vismodel(flowers, visual = "cie10", illum = "D65", vonkries = TRUE, relative = FALSE)
flowers.ciexyz <- colspace(vis.flowers, space = "ciexyz")
flowers.cielab <- colspace(vis.flowers, space = "cielab")
flowers.cielch <- colspace(vis.flowers, space = "cielch")
}
\references{
Smith T, Guild J. (1932) The CIE colorimetric standards and their use.
Transactions of the Optical Society, 33(3), 73-134.

Westland S, Ripamonti C, Cheung V. (2012). Computational colour science
using MATLAB. John Wiley & Sons.

Stockman, A., & Sharpe, L. T. (2000). Spectral sensitivities of
the middle- and long-wavelength sensitive cones derived from measurements in
observers of known genotype. Vision Research, 40, 1711-1737.

CIE (2006). Fundamental chromaticity diagram with physiological axes.
Parts 1 and 2. Technical Report 170-1. Vienna: Central Bureau of the Commission
Internationale de l Eclairage.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
