% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rspec.R
\name{plot.rspec}
\alias{plot.rspec}
\title{Plot spectra}
\usage{
\method{plot}{rspec}(x, select = NULL, type = c("overlay", "stack",
  "heatmap"), varying = NULL, n = 100, labels.stack = NULL, ...)
}
\arguments{
\item{x}{(required) a data frame, possibly an object of class \code{rspec},
with a column with wavelength data, named 'wl', and the remaining column containing
spectra to plot.}

\item{select}{specification of which spectra to plot. Can be a numeric vector or
factor (e.g., \code{sex=='male'})}

\item{type}{what type of plot should be drawn. Possibilities are:
\itemize{
\item \code{overlay} (default) for plotting multiple spectra in a single panel with
a common y-axis.
\item \code{stack} for plotting multiple spectra in a vertical arrangement.
\item \code{heatmap} for plotting reflectance values by wavelength and a third variable
(\code{varying}).
}}

\item{varying}{a numeric vector giving values for y-axis in \code{type = heatmap}.}

\item{n}{number of bins with which to interpolate colors and \code{varying} for the
heatplot.}

\item{labels.stack}{a vector of labels for the stacked spectra when using \code{type = stack}.
Defaults to the numeric column ID's.}

\item{...}{additional arguments passed to plot (or image for \code{"heatmap"}).}
}
\description{
Plots reflectance spectra in different arrangements.
}
\examples{
data(teal)
plot(teal, type = "overlay")
plot(teal, type = "stack")
plot(teal, type = "heatmap")
}
\seealso{
\code{\link[=spec2rgb]{spec2rgb()}}, \code{\link[=image]{image()}}, \code{\link[=plot]{plot()}}
}
\author{
Chad Eliason \email{cme16@zips.uakron.edu}

Thomas White \email{thomas.white026@gmail.com}
}
