% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interfaces.R
\name{distanceMetric}
\alias{distanceMetric}
\alias{distanceMetric.default}
\alias{distanceMetric.custom}
\title{Distance Metric Interface}
\usage{
distanceMetric(x, method = "euclidean", ...)

\method{distanceMetric}{default}(x, method = "euclidean", ...)

\method{distanceMetric}{custom}(x, method, ...)
}
\arguments{
\item{x}{Input data matrix or vector}

\item{method}{Custom function to compute distances}

\item{...}{Additional arguments passed to methods}
}
\value{
A distance object or matrix containing pairwise distances
}
\description{
A generic interface for computing distances between observations
using either built-in or custom distance metrics.
}
\details{
Generic Interface for Distance Metrics
}
\section{Methods (by class)}{
\itemize{
\item \code{distanceMetric(default)}: Default method using stats::dist

\item \code{distanceMetric(custom)}: Custom distance metric implementation

}}
\examples{
\dontrun{
# Using default method
x <- matrix(rnorm(100), ncol=2)
d1 <- distanceMetric(x, "euclidean")

# Using custom method
custom_dist <- function(x) as.dist(crossprod(x))
d2 <- distanceMetric(x, method=custom_dist)
}
}
