% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytical_functions.R
\name{get_velocity}
\alias{get_velocity}
\title{Get instantaneous velocity for subjects}
\usage{
get_velocity(
  obj_name,
  time_col = "time_sec",
  length_col = "position_length",
  width_col = "position_width",
  height_col = "position_height",
  add_to_viewr = TRUE,
  velocity_min = NA,
  velocity_max = NA,
  ...
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{time_col}{Name of the column containing time}

\item{length_col}{Name of the column containing length dimension}

\item{width_col}{Name of the column containing width dimension}

\item{height_col}{Name of the column containing height dimension}

\item{add_to_viewr}{Default TRUE; should velocity data be added as new
columns or should this function create a new simpler object?}

\item{velocity_min}{Should data below a certain velocity be filtered out of
the object? If so, enter a numeric. If not, keep NA.}

\item{velocity_max}{Should data above a certain velocity be filtered out of
the object? If so, enter a numeric. If not, keep NA.}

\item{...}{Additional arguments passed to or from other pathviewr functions.}
}
\value{
If \code{add_to_viewr} is \code{TRUE}, additional columns are
appended to the input viewr object. If \code{FALSE}, a standalone tibble is
created. Either way, an "instantaneous" velocity is computed as the
difference in position divided by the difference in time as each successive
row is encountered. Additionally, velocities along each of the three
position axes are computed and provided as additional columns.
}
\description{
Velocity (both overall and per-axis) is computed for each row in the data
(see Details)
}
\details{
Instantaneous velocity is not truly "instantaneous" but rather is
approximated as the change in distance divided by change in time from one
observation (row) to the previous observation (row). Each component of
velocity is computed (i.e. per axis) along with the overall velocity of
the subject.
}
\examples{
## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

## Clean the file. It is generally recommended to clean up to the
## "standarization" step before running get_velocity().
 motive_cleaned <-
   motive_data \%>\%
   relabel_viewr_axes() \%>\%
   gather_tunnel_data() \%>\%
   trim_tunnel_outliers() \%>\%
   rotate_tunnel()

## Now compute velocity and add as columns
 motive_velocity_added <-
   motive_cleaned \%>\%
   get_velocity(add_to_viewr = TRUE)

## Or set add_to_viewr to FALSE for a standalone object
 motive_velocity_standalone <-
   motive_cleaned \%>\%
   get_velocity(add_to_viewr = TRUE)
}
\seealso{
Other mathematical functions: 
\code{\link{calc_min_dist_v}()},
\code{\link{deg_2_rad}()},
\code{\link{find_curve_elbow}()},
\code{\link{get_2d_angle}()},
\code{\link{get_3d_angle}()},
\code{\link{get_3d_cross_prod}()},
\code{\link{get_dist_point_line}()},
\code{\link{get_traj_velocities}()},
\code{\link{rad_2_deg}()}
}
\author{
Vikram B. Baliga and Melissa S. Armstrong
}
\concept{mathematical functions}
