% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{redefine_tunnel_center}
\alias{redefine_tunnel_center}
\title{"Center" the tunnel data, i.e. translation but no rotation}
\usage{
redefine_tunnel_center(
  obj_name,
  axes = c("position_length", "position_width", "position_height"),
  length_method = c("original", "middle", "median", "user-defined"),
  width_method = c("original", "middle", "median", "user-defined"),
  height_method = c("original", "middle", "median", "user-defined"),
  length_zero = NA,
  width_zero = NA,
  height_zero = NA,
  ...
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{axes}{Names of axes to be centered}

\item{length_method}{Method for length}

\item{width_method}{Method for width}

\item{height_method}{Method for height}

\item{length_zero}{User-defined value}

\item{width_zero}{User-defined value}

\item{height_zero}{User-defined value}

\item{...}{Additional arguments passed to/from other pathviewr functions}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) in which data have
been translated according to the user's inputs, generally with \code{(0, 0,
  0,)} being relocated to the center of the tunnel.
}
\description{
Redefine the center \code{(0, 0, 0,)} of the tunnel data via translating
positions along axes.
}
\details{
For each \code{_method} argument, there are four choices of how centering is
handled: 1) "original" keeps axis as is -- this is how width and (possibly)
height should be handled for flydra data; 2) "middle" is the middle of the
range of data: (min + max) / 2; 3) "median" is the median value of data on
that axis. Probably not recommended; and 4) "user-defined" lets the user
customize where the (0, 0, 0) point in the tunnel will end up. Each
\code{_zero} argument is subtracted from its corresponding axis' data.
}
\examples{
## Import the Flydra example data included in
## the package
flydra_data <-
  read_flydra_mat(
    system.file("extdata",
                "pathviewr_flydra_example_data.mat",
                package = 'pathviewr'),
    subject_name = "birdie_wooster"
  )

## Re-center the Flydra data set.
## Width will be untouched
## Length will use the "middle" definition
## And height will be user-defined to be
## zeroed at 1.44 on the original axis
flydra_centered <-
  flydra_data \%>\%
  redefine_tunnel_center(length_method = "middle",
                         height_method = "user-defined",
                         height_zero = 1.44)
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{get_full_trajectories}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rename_viewr_characters}()},
\code{\link{rotate_tunnel}()},
\code{\link{select_x_percent}()},
\code{\link{separate_trajectories}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}

Other tunnel standardization functions: 
\code{\link{rotate_tunnel}()},
\code{\link{standardize_tunnel}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
\concept{tunnel standardization functions}
