% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udfs.R
\name{tx_translate}
\alias{tx_translate}
\title{Translate between value sets}
\usage{
tx_translate(
  codings,
  concept_map_uri,
  reverse = FALSE,
  equivalences = NULL,
  target = NULL
)
}
\arguments{
\item{codings}{A Column containing a struct representation of a Coding.}

\item{concept_map_uri}{An identifier for a FHIR ConceptMap.}

\item{reverse}{The direction to traverse the map. FALSE results in "source to target"
mappings, while TRUE results in "target to source".}

\item{equivalences}{A value of a collection of values from the ConceptMapEquivalence ValueSet.}

\item{target}{Identifies the value set in which a translation is sought. If there's no
target specified, the server should return all known translations.}
}
\value{
A Column containing the result of the operation (an array of Coding structs).
}
\description{
Takes a Coding column as input. Returns the Column which contains an array of
Coding value with translation targets from the specified FHIR ConceptMap. There
may be more than one target concept for each input concept. Only the translation with
the specified equivalences are returned.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pc <- pathling_connect()

# Translates the codings of the Condition `code` using a SNOMED implicit concept map.
pc \%>\% pathling_example_resource('Condition') \%>\%
    sparklyr::mutate(
         id,
         translation = !!tx_translate(code[['coding']],
                 'http://snomed.info/sct?fhir_cm=900000000000527005'),
         .keep='none')
 
pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{Equivalence}}

\href{https://pathling.csiro.au/docs/libraries/terminology#concept-translation}{Pathling documentation - Concept translation}

Other terminology functions: 
\code{\link{tx_display}()},
\code{\link{tx_member_of}()},
\code{\link{tx_property_of}()},
\code{\link{tx_subsumed_by}()},
\code{\link{tx_subsumes}()}
}
\concept{terminology functions}
