% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_country.R
\name{parse_country}
\alias{parse_country}
\title{Parse country names to standardized form}
\usage{
parse_country(x, to = "iso2c", how = c("regex", "google", "dstk"),
  language = c("en", "de"), factor = is.factor(x))
}
\arguments{
\item{x}{A character or factor vector of country names to standardize}

\item{to}{Format to which to convert. Defaults to \code{"iso2c"}; see \code{\link{codes}}
for more options.}

\item{how}{How to parse; defaults to \code{"regex"}. \code{"google"`` uses the Google Maps geocoding API;}"dstk"`` uses the Data Science Toolkit geocoding
API. See "Details" for more information.}

\item{language}{If \code{how = "regex"}, the language from which to parse country
names. Currently accepts \code{"en"} (default) and \code{"de"}. Ignored if
\code{how = "google"} or \code{how = "dstk".}}

\item{factor}{If \code{TRUE}, returns factor instead of character vector.}
}
\value{
A character vector or factor of ISO 2-character country codes or
other specified codes or names. Warns of any parsing failure.
}
\description{
\code{parse_country} parses irregular country names to the ISO 3166-1 Alpha-2 code
or other standardized code or name format.
}
\details{
\code{parse_country} tries to parse a character or factor vector of country names
to a standardized form: by default, ISO 3166-1 Alpha-2 codes.

When \code{how = "regex"} (default), \code{parse_country} uses regular expressions to
match irregular forms.

If regular expressions are insufficient, \code{how = "google"} will use the
Google Maps geocoding API instead, which permits a much broader range of
input formats and languages. The API allows 2500 calls per day, and should
thus be called judiciously. \code{parse_country} will make one call per unique
input. For more calls, see options that allow passing an API key like
\code{ggmap::geocode()} with \code{output = "all"} or \code{googleway::google_geocode()}.

If \code{how = "dstk"}, \code{parse_country} will use the Data Science Toolkit
geocoding API.

Note that due to their flexibility, the APIs may fail unpredictably, e.g.
\code{parse_country("foo", how = "google")} returns \code{"CH"} and
\code{parse_country("foo", how = "dstk")} returns \code{"DJ"} whereas \code{how = "regex"}
fails with a graceful \code{NA} and warning.
}
\examples{
parse_country(c("United States", "USA", "U.S.", "us", "United States of America"))

# Unicode support for parsing accented or non-Latin scripts
parse_country(c("\\u65e5\\u672c", "Japon", "\\u0698\\u0627\\u067e\\u0646"), how = "dstk")

# Parse distinct place names via geocoding APIs
parse_country(c("1600 Pennsylvania Ave, DC", "Eiffel Tower"), how = "dstk")

}
