% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipcw.R
\name{censoring_weights}
\alias{censoring_weights}
\alias{.censoring_weights_graf}
\alias{.censoring_weights_graf.default}
\alias{.censoring_weights_graf.workflow}
\alias{.censoring_weights_graf.model_fit}
\title{Calculations for inverse probability of censoring weights (IPCW)}
\usage{
.censoring_weights_graf(object, ...)

\method{.censoring_weights_graf}{default}(object, ...)

\method{.censoring_weights_graf}{workflow}(
  object,
  predictions,
  cens_predictors = NULL,
  trunc = 0.05,
  eps = 10^-10,
  ...
)

\method{.censoring_weights_graf}{model_fit}(
  object,
  predictions,
  cens_predictors = NULL,
  trunc = 0.05,
  eps = 10^-10,
  ...
)
}
\arguments{
\item{object}{A fitted parsnip model object or fitted workflow with a mode
of "censored regression".}

\item{predictions}{A data frame with a column containing a \code{\link[survival:Surv]{survival::Surv()}}
object as well as a list column called \code{.pred} that contains the data
structure produced by \code{\link[=predict.model_fit]{predict.model_fit()}}.}

\item{cens_predictors}{Not currently used. A potential future slot for models with
informative censoring based on columns in \code{predictions}.}

\item{trunc}{A potential lower bound for the probability of censoring to avoid
very large weight values.}

\item{eps}{A small value that is subtracted from the evaluation time when
computing the censoring probabilities. See Details below.}
}
\value{
The same data are returned with the \code{pred} tibbles containing
several new columns:
\itemize{
\item \code{.weight_time}: the time at which the inverse censoring probability weights
are computed. This is a function of the observed time and the time of
analysis (i.e., \code{eval_time}). See Details for more information.
\item \code{.pred_censored}: the probability of being censored at \code{.weight_time}.
\item \code{.weight_censored}: The inverse of the censoring probability.
}
}
\description{
The method of Graf \emph{et al} (1999) is used to compute weights at specific
evaluation times that can be used to help measure a model's time-dependent
performance (e.g. the time-dependent Brier score or the area under the ROC
curve). This is an internal function.
}
\details{
A probability that the data are censored immediately prior to a specific
time is computed. To do this, we must determine what time to
make the prediction. There are two time values for each row of the data set:
the observed time (either censored or not) and the time that the model is
being evaluated at (e.g. the survival function prediction at some time point),
which is constant across rows. .

From  Graf \emph{et al} (1999) there are three cases:
\itemize{
\item If the observed time is a censoring time and that is before the
evaluation time, the data point should make no contribution to the
performance metric (their "category 3"). These values have a missing
value for their probability estimate (and also for their weight column).
\item If the observed time corresponds to an actual event, and that time is
prior to the evaluation time (category 1), the probability of being
censored is predicted at the observed time (minus an epsilon).
\item If the observed time is \emph{after} the evaluation time (category 2), regardless of
the status, the probability of being censored is predicted at the evaluation
time (minus an epsilon).
}

The epsilon is used since, we would not have actual information at time \code{t}
for a data point being predicted at time \code{t} (only data prior to time \code{t}
should be available).

After the censoring probability is computed, the \code{trunc} option is used to
avoid using numbers pathologically close to zero. After this, the weight is
computed by inverting the censoring probability.

The \code{eps} argument is used to avoid information leakage when computing the
censoring probability. Subtracting a small number avoids using data that
would not be known at the time of prediction. For example, if we are making
survival probability predictions at \code{eval_time = 3.0}, we would \emph{not} know the
about the probability of being censored at that exact time (since it has not
occurred yet).

When creating weights by inverting probabilities, there is the risk that a few
cases will have severe outliers due to probabilities close to zero. To
mitigate this, the \code{trunc} argument can be used to put a cap on the weights.
If the smallest probability is greater than \code{trunc}, the probabilities with
values less than \code{trunc} are given that value. Otherwise,  \code{trunc} is
adjusted to be half of the smallest probability and that value is used as the
lower bound..

Note that if there are \code{n} rows in \code{data} and \code{t} time points, the resulting
data, once unnested, has \code{n * t} rows. Computations will not easily scale
well as \code{t} becomes very large.
}
\references{
Graf, E., Schmoor, C., Sauerbrei, W. and Schumacher, M. (1999),
Assessment and comparison of prognostic classification schemes for survival
data. \emph{Statist. Med.}, 18: 2529-2545.
}
\keyword{internal}
