% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_reg_stan.R
\name{details_poisson_reg_stan}
\alias{details_poisson_reg_stan}
\title{Poisson regression via stan}
\description{
\code{\link[rstanarm:stan_glm]{rstanarm::stan_glm()}} uses Bayesian estimation to fit a model for
count data.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This engine has no tuning parameters.
}

\subsection{Important engine-specific options}{

Some relevant arguments that can be passed to \code{set_engine()}:
\itemize{
\item \code{chains}: A positive integer specifying the number of Markov chains.
The default is 4.
\item \code{iter}: A positive integer specifying the number of iterations for
each chain (including warmup). The default is 2000.
\item \code{seed}: The seed for random number generation.
\item \code{cores}: Number of cores to use when executing the chains in
parallel.
\item \code{prior}: The prior distribution for the (non-hierarchical)
regression coefficients. The \code{"stan"} engine does not fit any
hierarchical terms.
\item \code{prior_intercept}: The prior distribution for the intercept (after
centering all predictors).
}

See \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} and
\code{\link[rstanarm:priors]{rstanarm::priors()}} for more information on these
and other options.
}

\subsection{Translation from parsnip to the original package}{

The \strong{poissonreg} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(poissonreg)

poisson_reg() \%>\% 
  set_engine("stan") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Computational engine: stan 
## 
## Model fit template:
## rstanarm::stan_glm(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), family = stats::poisson)
}\if{html}{\out{</div>}}

Note that the \code{refresh} default prevents logging of the estimation
process. Change this value in \code{set_engine()} to show the MCMC logs.
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.
}

\subsection{Other details}{

For prediction, the \code{"stan"} engine can compute posterior intervals
analogous to confidence and prediction intervals. In these instances,
the units are the original outcome. When \code{std_error = TRUE}, the
standard deviation of the posterior distribution (or posterior
predictive distribution as appropriate) is returned.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#linear-reg-stan}{examples}
for \code{poisson_reg()} with the \code{"stan"} engine.
}

\subsection{References}{
\itemize{
\item McElreath, R. 2020 \emph{Statistical Rethinking}. CRC Press.
}
}
}
\keyword{internal}
