% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_neighbor_kknn.R
\name{details_nearest_neighbor_kknn}
\alias{details_nearest_neighbor_kknn}
\title{K-nearest neighbors via kknn}
\description{
\code{\link[kknn:train.kknn]{kknn::train.kknn()}} fits a model that uses the \code{K} most similar data points
from the training set to predict new samples.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 3 tuning parameters:
\itemize{
\item \code{neighbors}: # Nearest Neighbors (type: integer, default: 5L)
\item \code{weight_func}: Distance Weighting Function (type: character,
default: ‘optimal’)
\item \code{dist_power}: Minkowski Distance Order (type: double, default: 2.0)
}
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nearest_neighbor(
  neighbors = integer(1),
  weight_func = character(1),
  dist_power = double(1)
) \%>\%  
  set_engine("kknn") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## K-Nearest Neighbor Model Specification (regression)
## 
## Main Arguments:
##   neighbors = integer(1)
##   weight_func = character(1)
##   dist_power = double(1)
## 
## Computational engine: kknn 
## 
## Model fit template:
## kknn::train.kknn(formula = missing_arg(), data = missing_arg(), 
##     ks = min_rows(0L, data, 5), kernel = character(1), distance = double(1))
}\if{html}{\out{</div>}}

\code{min_rows()} will adjust the number of neighbors if the chosen value if
it is not consistent with the actual data dimensions.
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nearest_neighbor(
  neighbors = integer(1),
  weight_func = character(1),
  dist_power = double(1)
) \%>\% 
  set_engine("kknn") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## K-Nearest Neighbor Model Specification (classification)
## 
## Main Arguments:
##   neighbors = integer(1)
##   weight_func = character(1)
##   dist_power = double(1)
## 
## Computational engine: kknn 
## 
## Model fit template:
## kknn::train.kknn(formula = missing_arg(), data = missing_arg(), 
##     ks = min_rows(0L, data, 5), kernel = character(1), distance = double(1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#nearest-neighbor-kknn}{examples}
for \code{nearest_neighbor()} with the \code{"kknn"} engine.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item Hechenbichler K. and Schliep K.P. (2004) \href{https://epub.ub.uni-muenchen.de/1769/}{Weighted k-Nearest-Neighbor Techniques and Ordinal Classification}, Discussion
Paper 399, SFB 386, Ludwig-Maximilians University Munich
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
