% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsedate-package.r
\name{parse_date}
\alias{parse_date}
\title{Parse date from any format}
\usage{
parse_date(dates, approx = TRUE, default_tz = "UTC")
}
\arguments{
\item{dates}{A character vector. An error is reported if
the function cannot coerce this parameter to a character vector.}

\item{approx}{Logical flag, whether the git parse should try
hard(er). If this is set to \code{TRUE}, then the current time is used
to fill in the missing parts of the date and time.}

\item{default_tz}{Time zone to assume for dates that don't specify a
time zone explicitly. Defaults to UTC, and an empty string means the
local time zone.}
}
\value{
A \code{POSIXct} vector. \code{NA} is returned for
  the dates that \code{parse_date} could not parse.
}
\description{
Recognize and parse dates from a wide range of formats. The current
algorithm is the following:
\enumerate{
  \item Try parsing dates using all valid ISO 8601 formats, by
    calling \code{\link{parse_iso_8601}}.
  \item If this fails, then try parsing them using the git
    date parser.
  \item If this fails, then try parsing them using \code{as.POSIXct}.
    (It is unlikely that this step will parse any dates that the
    first two steps couldn't, but it is still a logical fallback,
    to make sure that we can parse at least as many dates as
    \code{as.POSIXct}.
}
\code{parse_date} returns quickly in case of empty input elements.
}
\details{
All dates are returned in the UTC time zone. If you preder a different
time zone, simply use `.POSIXct()` on the result, see examples below.
}
\examples{
# Some easy examples
parse_date("2014-12-12")
parse_date("04/15/99")
parse_date("15/04/99")

# Ambiguous format, parsed assuming MM/DD/YY
parse_date("12/11/99")
parse_date("11/12/99")

# Fill in the current date and time
parse_date("03/20")
parse_date("12")

# But not for this, because this is ISO 8601
parse_date("2014")

# Handle vectors and empty input
parse_date(c("2014","2015","","2016"))

# Convert result to local time
tz <- format(Sys.time(), "\%Z")
as.POSIXct(parse_date("2014-12-13T11:12:13"), tz)

# Local time zone
parse_date("2014-12-13T11:12:13", default_tz = "CET")
parse_date("2014-12-13T11:12:13", default_tz = "UTC")

# Convert results to different timezone
parse_date("2015-12-13T11:12:13")
.POSIXct(parse_date("2015-12-13T11:12:13"), tz = "CET")
}
