% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableContent.R
\name{find_tableContent}
\alias{find_tableContent}
\alias{tableContent}
\alias{tableContent<-}
\title{Functions relating to the data content of a table}
\usage{
find_tableContent(table)

tableContent(table)

tableContent(table, asis = FALSE) <- value
}
\arguments{
\item{table}{A tabular-like environment to work with.}

\item{asis}{Should newlines be added around the
value?}

\item{value}{The content to be inserted into the cell.  This
can be a \link{LaTeX2} object, or a character string that will be
converted to one.}
}
\value{
\code{find_tableContent()} returns the indices of the
entries corresponding to content of the table.

\code{tableContent()} returns a \link{LaTeX2} object containing
all of the table content after the options.
}
\description{
Functions relating to the data content of a table
}
\details{
Unless \code{asis = TRUE}, \code{tableContent(table) <- value}
will add newlines
at the start end end if not present, to make the result
more readable.
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex")
parsed <- parseLatex(latex)
table <- parsed[[find_tabular(parsed)]]
table
tableContent(table)

tableContent(table) <- "Mazda RX4 & 21 & 6\\\\\\\\"
table
tableContent(table, asis = TRUE) <- "Mazda RX4 & 21 & 6\\\\\\\\"
table

}
