% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_matrix.R
\name{ci_matrix}
\alias{ci_matrix}
\title{Create confidence intervals for all coefficients.}
\usage{
ci_matrix(model_list, model_names = NULL, levels = c(0.95, 0.5))
}
\arguments{
\item{model_list}{A list of regression models.}

\item{model_names}{A list of names for the regression models (default is
\code{NULL}).}

\item{levels}{At most two confidence levels.}
}
\value{
A data frame of model coefficients with their respective confidence
 intervals.
}
\description{
Create confidence intervals for all coefficients across models, excluding the
intercept.
}
\details{
This function is called from \code{\link{coefficient_forestplot}} and might
not be of direct use for most users. Confidence intervals are obtained through
\code{confint} in the \code{stats} package. Intercepts are excluded from the
analysis as they don't relate to interactions or "effect modification," but
would be most analogous to an average effect.
}
\examples{
 states = as.data.frame(state.x77)

 m1 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='Northeast')
 m2 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='South')
 m3 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='North Central')
 m4 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='West')

 mList = list(m1, m2, m3, m4)

 paramhetero:::ci_matrix(model_list = mList, levels = 0.95)

}
