% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_value_special.R
\name{p_value.DirichletRegModel}
\alias{p_value.DirichletRegModel}
\alias{p_value.clm2}
\alias{p_value.cgam}
\alias{p_value.averaging}
\title{p-values for Models with Special Components}
\usage{
\method{p_value}{DirichletRegModel}(model, component = c("all", "conditional", "precision"), ...)

\method{p_value}{clm2}(model, component = c("all", "conditional", "scale"), ...)

\method{p_value}{cgam}(model, component = c("all", "conditional", "smooth_terms"), ...)

\method{p_value}{averaging}(model, component = c("conditional", "full"), ...)
}
\arguments{
\item{model}{A statistical model.}

\item{component}{Should all parameters, parameters for the conditional model, precision- or scale-component or smooth_terms be returned? \code{component} may be one of \code{"conditional"}, \code{"precision"}, \code{"scale"}, \code{"smooth_terms"}, \code{"full"} or \code{"all"} (default).}

\item{...}{Arguments passed down to \code{standard_error_robust()} when confidence intervals or p-values based on robust standard errors should be computed. Only available for models where \code{method = "robust"} is supported.}
}
\value{
The p-values.
}
\description{
This function attempts to return, or compute, p-values of models with special model components.
}
