% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_apa_results.R
\name{glue_apa_results}
\alias{glue_apa_results}
\alias{add_glue_to_apa_results}
\title{Create a New \code{apa_results} Object}
\usage{
glue_apa_results(x = NULL, term_names = NULL, ...)

add_glue_to_apa_results(
  ...,
  est_glue,
  stat_glue,
  container,
  sublist = NULL,
  term_names = NULL,
  in_paren = FALSE,
  est_first = TRUE,
  simplify = TRUE
)
}
\arguments{
\item{x}{An environment, list or data frame used to look up values for
substitution.}

\item{term_names}{Character. Used as names for the \code{estimate}-,
\code{statistics}-, and \code{full_result} sub-lists, if multiple estimates or
statistics are glued. Defaults to \code{attr(x, "sanitized_term_names")}.}

\item{...}{[\code{expressions}]\cr Unnamed arguments are taken to be expression
string(s) to format. Multiple inputs are concatenated together before formatting.
Named arguments are taken to be temporary variables available for substitution.}

\item{est_glue}{Character. (Named vector of) expressions string(s) to
format. Each string creates a new (named) element in the
\code{estimate} sub-list.}

\item{stat_glue}{Character. (Named vector of) expressions string(s) to
format. Each string creates a new (named) element in the
\code{statistic} sub-list.}

\item{container}{List of class \code{apa_results} to add the glued results to.}

\item{sublist}{Character. Name of (new) sub-list in \code{estimate}
\code{statistics}, and \code{full_result} to append glued results to (e.g.,
\code{modelfit}).}

\item{in_paren}{Logical. Whether the formatted string is to be reported in
parentheses. If \code{TRUE}, parentheses in the formatted string (e.g., those
enclosing degrees of freedom) are replaced with brackets.}

\item{est_first}{Logical. Determines in which order \code{estimate} and
\code{statistic} are glued together to \code{full_result}.}

\item{simplify}{Logical. Determines whether the \code{estimate}, \code{statistic}, and
\code{full_result} sub-lists should be simplified if only one term is
available from the model object.}
}
\value{
Returns a list of class \code{apa_results}, see \code{\link[=apa_print]{apa_print()}}.
}
\description{
Typeset the contents of an object according to the specified expression
strings and create a new or extend an existing \code{apa_results} object.
}
\examples{
# Tidy and typeset output
iris_lm <- lm(Sepal.Length ~ Petal.Length + Petal.Width, iris)
tidy_iris_lm <- broom::tidy(iris_lm, conf.int = TRUE)
tidy_iris_lm$p.value <- apa_p(tidy_iris_lm$p.value)

glance_iris_lm <- broom::glance(iris_lm)
glance_iris_lm$p.value <- apa_p(glance_iris_lm$p.value, add_equals = TRUE)
glance_iris_lm$df <- apa_num(as.integer(glance_iris_lm$df))
glance_iris_lm$df.residual <- apa_num(as.integer(glance_iris_lm$df.residual))

# Create `apa_results`-list
lm_results <- glue_apa_results(
    x = tidy_iris_lm
    , df = glance_iris_lm$df.residual
    , est_glue = "$b = <<estimate>>, 95\% CI $[<<conf.low>>,~<<conf.high>>]$"
    , stat_glue = "$t(<<df>>) = <<statistic>>$, $p <<p.value>>$"
    , term_names = make.names(names(coef(iris_lm)))
)

# Add modelfit information
add_glue_to_apa_results(
    .x = glance_iris_lm
    , container = lm_results
    , sublist = "modelfit"
    , est_glue = c(
        r2 = "$R^2 = <<r.squared>>$"
        , aic = ""
    )
    , stat_glue = c(
        r2 = "$F(<<df>>, <<df.residual>>) = <<statistic>>$, $p <<add_equals(p.value)>>$"
        , aic = "$\\\\mathrm{AIC} = <<AIC>>$"
    )
)
}
