% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-data.R
\name{split_data}
\alias{split_data}
\title{Function to transform data without time-dependent covariates into piece-wise
exponential data format}
\usage{
split_data(formula, data, cut = NULL, max_time = NULL, ...)
}
\arguments{
\item{formula}{a model formula}

\item{data}{a data frame}

\item{cut}{the vector of timepoints to cut at}

\item{max_time}{If \code{cut} is unspecified, a maximum time to be considered
can be specified through this argument. Then, all event times after \code{max_time}
will be administratively censored at \code{max_time}.}

\item{...}{Further arguments passed to \code{\link[survival]{survSplit}}}
}
\value{
A data frame class \code{ped} in piece-wise exponential data format.
}
\description{
Function to transform data without time-dependent covariates into piece-wise
exponential data format
}
\examples{
data("veteran", package="survival")
head(veteran)
ped <- split_data(Surv(time, status)~trt + age, data=veteran,
   cut=c(0, 100, 400), id="id")
head(ped)
class(ped) # class ped (piece-wise exponential data)
}
\seealso{
\code{\link[survival]{survSplit}}
}
\keyword{internal}
