% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{GTS2012}
\alias{GTS2012}
\title{Geological Timescale 2012}
\format{
A data frame with 186 rows and 9 variables:
\describe{
\item{interval_number}{Index number for the temporal order of all
intervals present in the dataset.}
\item{interval_name}{Names of intervals in the dataset.}
\item{rank}{The temporal rank of intervals in the dataset.}
\item{max_ma}{The maximum age of the interval in millions of years before
present.}
\item{mid_ma}{The midpoint age of the interval in millions of years before
present.}
\item{min_ma}{The minimum age of the interval in millions of years before
present.}
\item{duration_myr}{The duration of the interval in millions of years.}
\item{font}{Colour of font to use for plotting in conjunction with the
colour column.}
\item{colour}{Colours of stages based on the \href{https://stratigraphy.org/timescale/}{ICS timescale}.}
\item{abbr}{Standard abbreviations of interval names where appropiate.}
}
}
\source{
Compiled by Lewis A. Jones (2022-07-02) from the \href{https://stratigraphy.org/ICSchart/ChronostratChart2012.pdf}{ICS}.
}
\usage{
GTS2012
}
\description{
A dataframe of the Geological Timescale 2012. Age data from the
\href{https://stratigraphy.org/ICSchart/ChronostratChart2012.pdf}{International Commission on Stratigraphy}.
Supplementary information is also included in the dataset for plotting
functionality (e.g. GTS2012 colour scheme).
}
\section{References}{

Gradstein, F.M., Ogg, J.G., Schmitz, M.D. and Ogg, G.M. eds. (2012).
Geologic Timescale 2012. Elsevier.
\cr
}

\keyword{datasets}
