% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name-check.R
\name{pkg_name_check}
\alias{pkg_name_check}
\title{Check if an R package name is available}
\usage{
pkg_name_check(name, dictionaries = NULL)
}
\arguments{
\item{name}{Package name candidate.}

\item{dictionaries}{Character vector, the dictionaries to query.
Available dictionaries:
* \code{wikipedia}
* \code{wiktionary},
* \code{sentiment} (\url{https://github.com/fnielsen/afinn}),
* \code{urban} (Urban Dictionary).
If \code{NULL} (by default), the Urban Dictionary is omitted, as it
is often offensive.}
}
\value{
\code{pkg_name_check} object with a custom print method.
}
\description{
Additionally, look up the candidate name in a number of
dictionaries, to make sure that it does not have a negative
meaning.
}
\details{
\subsection{Valid package name check}{

Check the validity of \code{name} as a package name. See 'Writing R
Extensions' for the allowed package names. Also checked against a list
of names that are known to cause problems.
}

\subsection{CRAN checks}{

Check \code{name} against the names of all past and current packages on
CRAN, including base and recommended packages.
}

\subsection{Bioconductor checks}{

Check \code{name} against all past and current Bioconductor packages.
}

\subsection{Profanity check}{

Check \code{name} with \url{https://www.purgomalum.com/service/containsprofanity}
to make sure it is not a profanity.
}

\subsection{Dictionaries}{

See the \code{dictionaries} argument.
}
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{pkg_name_check("sicily")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #B58900;">╔══════════════════════════════════════════════════════════════════════╗</span>
#> <span style="color: #B58900;">║</span>                            <span style="color: #B58900;">–*–</span> <span style="font-weight: bold;color: #268BD2;">sicily</span> <span style="color: #B58900;">–*–</span>                            <span style="color: #B58900;">║</span>
#> <span style="color: #B58900;">╚══════════════════════════════════════════════════════════════════════╝</span>
#> <span style="color: #525252;">┌──────────────────────────────────────────────────────────────────────┐</span>
#> <span style="color: #525252;">│</span> <span style="color: #859900;">v</span>  valid name          <span style="color: #859900;">v</span>  CRAN               <span style="color: #859900;">v</span>  Bioconductor         <span style="color: #525252;">│</span>
#> <span style="color: #525252;">│</span> <span style="color: #859900;">v</span>  not a profanity                                                   <span style="color: #525252;">│</span>
#> <span style="color: #525252;">└──────────────────────────────────────────────────────────────────────┘</span>
#> <span style="color: #525252;">┌ </span><span style="color: #859900;">Wikipedia</span><span style="color: #525252;"> ───────────────────────────────────────────────────────────┐</span>
#> <span style="color: #525252;">│</span> <span style="text-decoration: underline;">Sicily</span> Sicily (Italian: Sicilia [siˈtʃiːlja], Sicilian               <span style="color: #525252;">│</span>
#> <span style="color: #525252;">│</span> pronunciation: [sɪˈʃiːlja]) is the largest island in the             <span style="color: #525252;">│</span>
#> <span style="color: #525252;">│</span> Mediterranean Sea and one of the 20 regions of Italy. The Strait of  <span style="color: #525252;">│</span>
#> <span style="color: #525252;">│</span> Messina divides it from the region of Calabria in Southern Italy.    <span style="color: #525252;">│</span>
#> <span style="color: #525252;">│</span> It is one of the five Italian autonomous regions and is officially   <span style="color: #525252;">│</span>
#> <span style="color: #525252;">│</span> referred to as Regione Siciliana. The region has 5 million           <span style="color: #525252;">│</span>
#> <span style="color: #525252;">│</span> …                                                                    <span style="color: #525252;">│</span>
#> <span style="color: #525252;">└──────────────────────────────── </span><span style="color: #268BD2;">https://en.wikipedia.org/wiki/Sicily</span><span style="color: #525252;"> ┘</span>
#> <span style="color: #525252;">┌ </span><span style="color: #859900;">Wiktionary</span><span style="color: #525252;"> ──────────────────────────────────────────────────────────┐</span>
#> <span style="color: #525252;">│</span> <span style="text-decoration: underline;">sicily</span> No English definition found                                   <span style="color: #525252;">│</span>
#> <span style="color: #525252;">└────────────────────────────────────────────────────────────────────  ┘</span>
#> <span style="color: #525252;">┌──────────────────────────────────────────────────────────────────────┐</span>
#> <span style="color: #525252;">│</span> Sentiment: 😐<span style="color: #525252;"> (0)</span>                                                    <span style="color: #525252;">│</span> 
#> <span style="color: #525252;">└──────────────────────────────────────────────────────────────────────┘</span>
</pre></div>
}}
}

