% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{tldr}
\alias{tldr}
\title{Simplified manual. Start here!}
\description{
You don't need to read long manual pages for a simple task.
This manual page collects the most common pak use cases.
}
\section{Package installation}{
\subsection{Install a package from CRAN or Bioconductor}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble")
}\if{html}{\out{</div>}}

\if{html}{\figure{tldr-cran.svg}}
}

\subsection{Install a package from GitHub}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tidyverse/tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> → Will <span style="font-style: italic;">update</span> 2 packages.                                                       
#> → All 2 packages (0 B) are cached.                                              
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">tibble</span> 3.1.8 → 3.1.8<span style="font-weight: bold;">.9001</span> 👷🏾🔧 (GitHub: 44d905f)                               
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">vctrs</span>  0.4.1 → 0.4.1<span style="font-weight: bold;">.9000</span> 👷🏻‍♂️🔧 (GitHub: 5191dfc)                            
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 2 pkgs are cached                                    
#> <span style="color: #859900;">✔</span> Got <span style="color: #268BD2;">vctrs</span> 0.4.1.9000 (source) (2.07 MB)                                       
#> <span style="color: #859900;">✔</span> Got <span style="color: #268BD2;">tibble</span> 3.1.8.9001 (source) (1.34 MB)                                      
#> <span style="color: #2AA198;">ℹ</span> Packaging <span style="color: #268BD2;">vctrs</span> 0.4.1.9000                                                    
#> <span style="color: #859900;">✔</span> Packaged <span style="color: #268BD2;">vctrs</span> 0.4.1.9000 <span style="color: #a3a3a3;">(1.3s)</span>                                              
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">vctrs</span> 0.4.1.9000                                                     
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">vctrs</span> 0.4.1.9000 <span style="color: #a3a3a3;">(9.7s)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">vctrs</span> 0.4.1.9000 (github::r-lib/vctrs@5191dfc) <span style="color: #a3a3a3;">(29ms)</span>               
#> <span style="color: #2AA198;">ℹ</span> Packaging <span style="color: #268BD2;">tibble</span> 3.1.8.9001                                                   
#> <span style="color: #859900;">✔</span> Packaged <span style="color: #268BD2;">tibble</span> 3.1.8.9001 <span style="color: #a3a3a3;">(437ms)</span>                                            
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tibble</span> 3.1.8.9001                                                    
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tibble</span> 3.1.8.9001 <span style="color: #a3a3a3;">(2.5s)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.8.9001 (github::tidyverse/tibble@44d905f) <span style="color: #a3a3a3;">(42ms)</span>         
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 8, upd 2, dld 2 (NA B) <span style="color: #b8b8b8;">[17.7s]</span>                          
</pre></div>
}}

}

\subsection{Install a package from a URL}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("url::https://cran.r-project.org/src/contrib/Archive/tibble/tibble_3.1.7.tar.gz")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> → Will <span style="font-style: italic;">install</span> 1 package.                                                       
#> → Will <span style="font-style: italic;">update</span> 1 package.                                                        
#> → All 2 packages (38.65 kB) are cached.                                         
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">ellipsis</span>              0.3.2                                                   
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">tibble</span>   3.1.8.9001 → 3.1.<span style="font-weight: bold;">7</span> 👷🏻‍♀️🔧                                            
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 2 pkgs (38.65 kB) are cached                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">ellipsis</span> 0.3.2  <span style="color: #a3a3a3;">(13ms)</span>                                              
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tibble</span> 3.1.7                                                         
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tibble</span> 3.1.7 <span style="color: #a3a3a3;">(2.5s)</span>                                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.7  <span style="color: #a3a3a3;">(24ms)</span>                                                
#> <span style="color: #859900;">✔</span> 1 pkg + 11 deps: kept 9, upd 1, added 1 <span style="color: #b8b8b8;">[3.4s]</span>                                
</pre></div>
}}

}
}

\section{Package updates}{
\subsection{Update a package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> → Will <span style="font-style: italic;">update</span> 1 package.                                                        
#> → The package (724.32 kB) is cached.                                            
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">tibble</span> 3.1.7 → 3.1.<span style="font-weight: bold;">8</span>                                                          
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg (724.32 kB) is cached                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.8  <span style="color: #a3a3a3;">(29ms)</span>                                                
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 9, upd 1 <span style="color: #b8b8b8;">[572ms]</span>                                        
</pre></div>
}}

}

\subsection{Update all dependencies of a package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble", upgrade = TRUE)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> → Will <span style="font-style: italic;">update</span> 1 package.                                                        
#> → The package (495.82 kB) is cached.                                            
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">cli</span> 3.3.0 → 3.<span style="font-weight: bold;">4.0</span> 👷🏼🔧                                                         
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg (495.82 kB) is cached                          
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">cli</span> 3.4.0                                                            
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">cli</span> 3.4.0 <span style="color: #a3a3a3;">(4.6s)</span>                                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">cli</span> 3.4.0  <span style="color: #a3a3a3;">(35ms)</span>                                                   
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 10, upd 1 <span style="color: #b8b8b8;">[5.2s]</span>                                        
</pre></div>
}}

}
}

\section{Dependency lookup}{
\subsection{Dependencies of a CRAN or Bioconductor package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_deps("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 11 × 32</span>                                                         
#>    ref       type  direct direc…¹ status package version license needs…² prior…³
#>    <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>     <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;lgl&gt;</span>  <span style="font-style: italic;color: #999999;">&lt;lgl&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;lgl&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;"> 1</span> fansi     stan… FALSE  FALSE   OK     fansi   1.0.3   GPL-2 … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 2</span> glue      stan… FALSE  FALSE   OK     glue    1.6.2   MIT + … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 3</span> lifecycle stan… FALSE  FALSE   OK     lifecy… 1.0.1   MIT + … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 4</span> magrittr  stan… FALSE  FALSE   OK     magrit… 2.0.3   MIT + … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 5</span> pillar    stan… FALSE  FALSE   OK     pillar  1.8.1   MIT + … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 6</span> pkgconfig stan… FALSE  FALSE   OK     pkgcon… 2.0.3   MIT + … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 7</span> rlang     stan… FALSE  FALSE   OK     rlang   1.0.5   MIT + … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 8</span> tibble    stan… TRUE   TRUE    OK     tibble  3.1.8   MIT + … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 9</span> utf8      stan… FALSE  FALSE   OK     utf8    1.2.2   Apache… FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">10</span> vctrs     stan… FALSE  FALSE   OK     vctrs   0.4.1   MIT + … FALSE   <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">11</span> cli       stan… FALSE  FALSE   OK     cli     3.4.0   MIT + … TRUE    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #999999;"># … with 22 more variables: md5sum &lt;chr&gt;, sha256 &lt;chr&gt;, filesize &lt;int&gt;,</span>         
#> <span style="color: #999999;">#   built &lt;chr&gt;, platform &lt;chr&gt;, rversion &lt;chr&gt;, repotype &lt;chr&gt;, repodir &lt;chr&gt;,</span> 
#> <span style="color: #999999;">#   target &lt;chr&gt;, deps &lt;list&gt;, mirror &lt;chr&gt;, sources &lt;list&gt;, remote &lt;list&gt;,</span>     
#> <span style="color: #999999;">#   error &lt;list&gt;, metadata &lt;list&gt;, dep_types &lt;list&gt;, params &lt;list&gt;,</span>             
#> <span style="color: #999999;">#   sysreqs &lt;chr&gt;, cache_status &lt;chr&gt;, lib_status &lt;chr&gt;, old_version &lt;chr&gt;,</span>     
#> <span style="color: #999999;">#   new_version &lt;chr&gt;, and abbreviated variable names ¹​directpkg,</span>              
#> <span style="color: #999999;">#   ²​needscompilation, ³​priority</span>                                              
</pre></div>
}}

}

\subsection{Depenendency tree of a CRAN / Bioconductor package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_deps_tree("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="font-weight: bold;font-style: italic;color: #2AA198;">tibble </span><span style="font-weight: bold;font-style: italic;color: #002B36;">3.1.8</span> <span style="color: #859900;">✨</span>                                                                  
#> ├─fansi <span style="color: #002B36;">1.0.3</span> <span style="color: #859900;">✨</span>                                                                 
#> ├─lifecycle <span style="color: #002B36;">1.0.1</span> <span style="color: #859900;">✨</span>                                                             
#> │ ├─glue <span style="color: #002B36;">1.6.2</span> <span style="color: #859900;">✨</span>                                                                
#> │ └─rlang <span style="color: #002B36;">1.0.5</span> <span style="color: #859900;">✨</span>                                                               
#> ├─magrittr <span style="color: #002B36;">2.0.3</span> <span style="color: #859900;">✨</span>                                                              
#> ├─pillar <span style="color: #002B36;">1.8.1</span> <span style="color: #859900;">✨</span>                                                                
#> │ ├─cli <span style="color: #002B36;">3.4.0</span> <span style="color: #859900;">✨👷‍♀️🔧   </span>                                                         
#> │ ├─fansi                                                                       
#> │ ├─glue                                                                        
#> │ ├─lifecycle                                                                   
#> │ ├─rlang                                                                       
#> │ ├─utf8 <span style="color: #002B36;">1.2.2</span> <span style="color: #859900;">✨</span>                                                                
#> │ └─vctrs <span style="color: #002B36;">0.4.1</span> <span style="color: #859900;">✨</span>                                                               
#> │   ├─cli                                                                       
#> │   ├─glue                                                                      
#> │   └─rlang                                                                     
#> ├─pkgconfig <span style="color: #002B36;">2.0.3</span> <span style="color: #859900;">✨</span>                                                             
#> ├─rlang                                                                         
#> └─vctrs                                                                         
#>                                                                                 
#> Key:  <span style="color: #859900;">✨</span> new | <span style="color: #859900;">👷‍♀️ bu</span>ild | 🔧 c<span style="color: #859900;">o</span>mpile                                            
</pre></div>
}}

}

\subsection{Dependency trre of a package on GitHub}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_deps_tree("tidyverse/tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="font-weight: bold;font-style: italic;color: #2AA198;">tidyverse/tibble </span><span style="font-weight: bold;font-style: italic;color: #002B36;">3.1.8.9001</span> <span style="color: #859900;">✨👷🏼‍♂️🔧    </span>                                         
#> ├─fansi <span style="color: #002B36;">1.0.3</span> <span style="color: #859900;">✨</span>                                                                 
#> ├─lifecycle <span style="color: #002B36;">1.0.1</span> <span style="color: #859900;">✨</span>                                                             
#> │ ├─glue <span style="color: #002B36;">1.6.2</span> <span style="color: #859900;">✨</span>                                                                
#> │ └─rlang <span style="color: #002B36;">1.0.5</span> <span style="color: #859900;">✨</span>                                                               
#> ├─magrittr <span style="color: #002B36;">2.0.3</span> <span style="color: #859900;">✨</span>                                                              
#> ├─pillar <span style="color: #002B36;">1.8.1</span> <span style="color: #859900;">✨</span>                                                                
#> │ ├─cli <span style="color: #002B36;">3.4.0</span> <span style="color: #859900;">✨👷🏼‍♂️🔧    </span>                                                       
#> │ ├─fansi                                                                       
#> │ ├─glue                                                                        
#> │ ├─lifecycle                                                                   
#> │ ├─rlang                                                                       
#> │ ├─utf8 <span style="color: #002B36;">1.2.2</span> <span style="color: #859900;">✨</span>                                                                
#> │ └─r-lib/vctrs <span style="color: #002B36;">0.4.1.9000</span> <span style="color: #859900;">✨👷🏼‍♂️🔧    </span>                                          
#> │   ├─cli                                                                       
#> │   ├─glue                                                                      
#> │   └─rlang                                                                     
#> ├─pkgconfig <span style="color: #002B36;">2.0.3</span> <span style="color: #859900;">✨</span>                                                             
#> ├─rlang                                                                         
#> └─r-lib/vctrs                                                                   
#>                                                                                 
#> Key:  <span style="color: #859900;">✨</span> new | <span style="color: #859900;">👷🏼‍♂️ bui</span>ld | 🔧 co<span style="color: #859900;">m</span>pile                                           
</pre></div>
}}

}

\subsection{Dependency tree of the package in the current directory}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_deps_tree("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="font-weight: bold;font-style: italic;color: #2AA198;">local::tibble </span><span style="font-weight: bold;font-style: italic;color: #002B36;">3.1.8</span> <span style="color: #859900;">✨👷🏻🔧 </span>                                                       
#> ├─fansi <span style="color: #002B36;">1.0.3</span> <span style="color: #859900;">✨</span>                                                                 
#> ├─lifecycle <span style="color: #002B36;">1.0.1</span> <span style="color: #859900;">✨</span>                                                             
#> │ ├─glue <span style="color: #002B36;">1.6.2</span> <span style="color: #859900;">✨</span>                                                                
#> │ └─rlang <span style="color: #002B36;">1.0.5</span> <span style="color: #859900;">✨</span>                                                               
#> ├─magrittr <span style="color: #002B36;">2.0.3</span> <span style="color: #859900;">✨</span>                                                              
#> ├─pillar <span style="color: #002B36;">1.8.1</span> <span style="color: #859900;">✨</span>                                                                
#> │ ├─cli <span style="color: #002B36;">3.4.0</span> <span style="color: #859900;">✨👷🏻🔧 </span>                                                             
#> │ ├─fansi                                                                       
#> │ ├─glue                                                                        
#> │ ├─lifecycle                                                                   
#> │ ├─rlang                                                                       
#> │ ├─utf8 <span style="color: #002B36;">1.2.2</span> <span style="color: #859900;">✨</span>                                                                
#> │ └─vctrs <span style="color: #002B36;">0.4.1</span> <span style="color: #859900;">✨</span>                                                               
#> │   ├─cli                                                                       
#> │   ├─glue                                                                      
#> │   └─rlang                                                                     
#> ├─pkgconfig <span style="color: #002B36;">2.0.3</span> <span style="color: #859900;">✨</span>                                                             
#> ├─rlang                                                                         
#> └─vctrs                                                                         
#>                                                                                 
#> Key:  <span style="color: #859900;">✨</span> new | <span style="color: #859900;">👷🏻 </span>build | 🔧<span style="color: #859900;"> </span>compile                                              
</pre></div>
}}


(Assuming package is in directory \code{tibble}.)
}

\subsection{Explain a recursive dependency}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_deps_explain("tibble", "rlang")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> tibble -&gt; lifecycle -&gt; rlang                                                    
#> tibble -&gt; pillar -&gt; lifecycle -&gt; rlang                                          
#> tibble -&gt; pillar -&gt; rlang                                                       
#> tibble -&gt; pillar -&gt; vctrs -&gt; rlang                                              
#> tibble -&gt; rlang                                                                 
#> tibble -&gt; vctrs -&gt; rlang                                                        
</pre></div>
}}

}
}

\section{Package development}{
\subsection{Install dependencies of local package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_install_deps()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #859900;">✔</span> Updated metadata database: 1.42 MB in 5 files.                                
#> <span style="color: #2AA198;">ℹ</span> R 4.2 aarch64-apple-darwin20 packages are missing from Bioconductor           
#> <span style="color: #859900;">✔</span> Updating metadata database ... done                                           
#>                                                                                 
#> → The package (0 B) is cached.                                                  
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed                                                       
#> <span style="color: #859900;">✔</span> 10 deps: kept 10 <span style="color: #b8b8b8;">[7.4s]</span>                                                       
</pre></div>
}}

}

\subsection{Install local package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_install()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> → Will <span style="font-style: italic;">update</span> 1 package.                                                        
#> → The package (0 B) is cached.                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">tibble</span> 3.1.8 → 3.1.8 👷🏻‍♀️🔧                                                   
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg is cached                                      
#> <span style="color: #859900;">✔</span> Got <span style="color: #268BD2;">tibble</span> 3.1.8 (source) (96 B)                                              
#> <span style="color: #2AA198;">ℹ</span> Packaging <span style="color: #268BD2;">tibble</span> 3.1.8                                                        
#> <span style="color: #859900;">✔</span> Packaged <span style="color: #268BD2;">tibble</span> 3.1.8 <span style="color: #a3a3a3;">(639ms)</span>                                                 
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tibble</span> 3.1.8                                                         
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tibble</span> 3.1.8 <span style="color: #a3a3a3;">(2.2s)</span>                                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.8 (local) <span style="color: #a3a3a3;">(28ms)</span>                                         
#> <span style="color: #859900;">✔</span> 1 pkg + 10 deps: kept 10, upd 1, dld 1 (NA B) <span style="color: #b8b8b8;">[3.9s]</span>                          
</pre></div>
}}

}

\subsection{Install all dependencies of local package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::local_install_dev_deps()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                                 
#> → Will <span style="font-style: italic;">install</span> 86 packages.                                                     
#> → Will <span style="font-style: italic;">update</span> 2 packages.                                                       
#> → Will <span style="font-style: italic;">download</span> 1 CRAN package (1.33 MB), cached: 88 (96.03 MB).                
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">askpass</span>                1.1                                                    
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">base64enc</span>              0.1-3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">bench</span>                  1.1.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">bit</span>                    4.0.4                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">bit64</span>                  4.0.5                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">blob</span>                   1.2.3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">brio</span>                   1.1.3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">bslib</span>                  0.4.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">cachem</span>                 1.0.6                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">callr</span>                  3.7.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">clipr</span>                  0.8.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">colorspace</span>             2.0-3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">covr</span>                   3.6.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">cpp11</span>                  0.4.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">crayon</span>                 1.5.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">curl</span>                   4.3.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">desc</span>                   1.4.2    👷🏻                                            
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">DiagrammeR</span>             1.0.9                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">diffobj</span>                0.3.5                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">digest</span>                 0.6.29                                                 
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">downloader</span>             0.4                                                    
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">dplyr</span>                  1.0.10    ⬇ <span style="color: #002B36;">(1.33 MB)</span>                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">evaluate</span>               0.16                                                   
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">farver</span>                 2.1.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">fastmap</span>                1.1.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">formattable</span>            0.2.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">fs</span>                     1.5.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">generics</span>               0.1.3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">ggplot2</span>                3.3.6                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">gridExtra</span>              2.3                                                    
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">gtable</span>                 0.3.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">highr</span>                  0.9                                                    
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">hms</span>                    1.1.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">htmltools</span>              0.5.3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">htmlwidgets</span>            1.5.4                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">httr</span>                   1.4.4                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">igraph</span>                 1.3.4                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">influenceR</span>             0.1.0.1                                                
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">isoband</span>                0.2.5                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">jquerylib</span>              0.1.4                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">jsonlite</span>               1.8.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">knitr</span>                  1.40                                                   
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">labeling</span>               0.4.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">lazyeval</span>               0.2.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">lubridate</span>              1.8.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">MASS</span>         7.3-57  → 7.3-<span style="font-weight: bold;">58.1</span>                                               
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">memoise</span>                2.0.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">mime</span>                   0.12                                                   
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">mockr</span>                  0.2.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">munsell</span>                0.5.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">nlme</span>         3.1-157 → 3.1-<span style="font-weight: bold;">159</span>                                                
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">nycflights13</span>           1.0.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">openssl</span>                2.0.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">pkgbuild</span>               1.3.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">pkgload</span>                1.3.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">praise</span>                 1.0.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">prettyunits</span>            1.1.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">processx</span>               3.7.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">profmem</span>                0.6.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">ps</span>                     1.7.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">purrr</span>                  0.3.4                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">R6</span>                     2.5.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">rappdirs</span>               0.3.3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">RColorBrewer</span>           1.1-3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">readr</span>                  2.1.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">rematch2</span>               2.1.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">rex</span>                    1.2.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">rmarkdown</span>              2.16                                                   
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">rprojroot</span>              2.0.3                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">rstudioapi</span>             0.14                                                   
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">sass</span>                   0.4.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">scales</span>                 1.2.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">stringi</span>                1.7.8                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">stringr</span>                1.4.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">sys</span>                    3.4                                                    
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">testthat</span>               3.1.4                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">tidyr</span>                  1.2.1    👷🏿🔧                                           
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">tidyselect</span>             1.1.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">tinytex</span>                0.41                                                   
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">tzdb</span>                   0.3.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">viridis</span>                0.6.2                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">viridisLite</span>            0.4.1                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">visNetwork</span>             2.1.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">vroom</span>                  1.5.7                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">waldo</span>                  0.4.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">withr</span>                  2.5.0                                                  
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">xfun</span>                   0.32                                                   
#> <span style="color: #002B36;">+ </span><span style="color: #268BD2;">yaml</span>                   2.3.5                                                  
#> <span style="color: #2AA198;">ℹ</span> Getting 1 pkg (1.33 MB), 87 (96.03 MB) cached                                 
#> <span style="color: #859900;">✔</span> Got <span style="color: #268BD2;">tidyr</span> 1.2.1 (source) (746.06 kB)                                          
#> <span style="color: #859900;">✔</span> Got <span style="color: #268BD2;">gtable</span> 0.3.1 (aarch64-apple-darwin20) (159.19 kB)                         
#> <span style="color: #859900;">✔</span> Got <span style="color: #268BD2;">dplyr</span> 1.0.10 (aarch64-apple-darwin20) (1.33 MB)                           
#> <span style="color: #2AA198;">ℹ</span> Packaging <span style="color: #268BD2;">tibble</span> 3.1.8                                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">DiagrammeR</span> 1.0.9  <span style="color: #a3a3a3;">(75ms)</span>                                            
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">MASS</span> 7.3-58.1  <span style="color: #a3a3a3;">(83ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">R6</span> 2.5.1  <span style="color: #a3a3a3;">(89ms)</span>                                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">RColorBrewer</span> 1.1-3  <span style="color: #a3a3a3;">(95ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">askpass</span> 1.1  <span style="color: #a3a3a3;">(102ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">base64enc</span> 0.1-3  <span style="color: #a3a3a3;">(106ms)</span>                                            
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">bench</span> 1.1.2  <span style="color: #a3a3a3;">(144ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">bit64</span> 4.0.5  <span style="color: #a3a3a3;">(41ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">bit</span> 4.0.4  <span style="color: #a3a3a3;">(95ms)</span>                                                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">blob</span> 1.2.3  <span style="color: #a3a3a3;">(125ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">brio</span> 1.1.3  <span style="color: #a3a3a3;">(58ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">cachem</span> 1.0.6  <span style="color: #a3a3a3;">(15ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">callr</span> 3.7.2  <span style="color: #a3a3a3;">(20ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">clipr</span> 0.8.0  <span style="color: #a3a3a3;">(38ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">bslib</span> 0.4.0  <span style="color: #a3a3a3;">(165ms)</span>                                                
#> <span style="color: #859900;">✔</span> Packaged <span style="color: #268BD2;">tibble</span> 3.1.8 <span style="color: #a3a3a3;">(597ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">colorspace</span> 2.0-3  <span style="color: #a3a3a3;">(67ms)</span>                                            
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">covr</span> 3.6.1  <span style="color: #a3a3a3;">(53ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">cpp11</span> 0.4.2  <span style="color: #a3a3a3;">(59ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">crayon</span> 1.5.1  <span style="color: #a3a3a3;">(39ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">curl</span> 4.3.2  <span style="color: #a3a3a3;">(41ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">diffobj</span> 0.3.5  <span style="color: #a3a3a3;">(61ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">digest</span> 0.6.29  <span style="color: #a3a3a3;">(39ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">downloader</span> 0.4  <span style="color: #a3a3a3;">(27ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">dplyr</span> 1.0.10  <span style="color: #a3a3a3;">(25ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">evaluate</span> 0.16  <span style="color: #a3a3a3;">(12ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">farver</span> 2.1.1  <span style="color: #a3a3a3;">(23ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">fastmap</span> 1.1.0  <span style="color: #a3a3a3;">(14ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">formattable</span> 0.2.1  <span style="color: #a3a3a3;">(35ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">fs</span> 1.5.2  <span style="color: #a3a3a3;">(20ms)</span>                                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">generics</span> 0.1.3  <span style="color: #a3a3a3;">(12ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">ggplot2</span> 3.3.6  <span style="color: #a3a3a3;">(35ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">gridExtra</span> 2.3  <span style="color: #a3a3a3;">(18ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">gtable</span> 0.3.1  <span style="color: #a3a3a3;">(15ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">highr</span> 0.9  <span style="color: #a3a3a3;">(14ms)</span>                                                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">hms</span> 1.1.2  <span style="color: #a3a3a3;">(14ms)</span>                                                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">htmltools</span> 0.5.3  <span style="color: #a3a3a3;">(15ms)</span>                                             
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">htmlwidgets</span> 1.5.4  <span style="color: #a3a3a3;">(20ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">httr</span> 1.4.4  <span style="color: #a3a3a3;">(18ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">igraph</span> 1.3.4  <span style="color: #a3a3a3;">(67ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">influenceR</span> 0.1.0.1  <span style="color: #a3a3a3;">(13ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">isoband</span> 0.2.5  <span style="color: #a3a3a3;">(37ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">jquerylib</span> 0.1.4  <span style="color: #a3a3a3;">(18ms)</span>                                             
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">jsonlite</span> 1.8.0  <span style="color: #a3a3a3;">(40ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">knitr</span> 1.40  <span style="color: #a3a3a3;">(46ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">labeling</span> 0.4.2  <span style="color: #a3a3a3;">(11ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">lazyeval</span> 0.2.2  <span style="color: #a3a3a3;">(14ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">lubridate</span> 1.8.0  <span style="color: #a3a3a3;">(26ms)</span>                                             
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">memoise</span> 2.0.1  <span style="color: #a3a3a3;">(11ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">mime</span> 0.12  <span style="color: #a3a3a3;">(12ms)</span>                                                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">mockr</span> 0.2.0  <span style="color: #a3a3a3;">(29ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">munsell</span> 0.5.0  <span style="color: #a3a3a3;">(14ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">nlme</span> 3.1-159  <span style="color: #a3a3a3;">(27ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">nycflights13</span> 1.0.2  <span style="color: #a3a3a3;">(18ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">openssl</span> 2.0.2  <span style="color: #a3a3a3;">(33ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">pkgbuild</span> 1.3.1  <span style="color: #a3a3a3;">(11ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">pkgload</span> 1.3.0  <span style="color: #a3a3a3;">(12ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">praise</span> 1.0.0  <span style="color: #a3a3a3;">(30ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">prettyunits</span> 1.1.1  <span style="color: #a3a3a3;">(11ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">processx</span> 3.7.0  <span style="color: #a3a3a3;">(16ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">profmem</span> 0.6.0  <span style="color: #a3a3a3;">(12ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">ps</span> 1.7.1  <span style="color: #a3a3a3;">(14ms)</span>                                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">purrr</span> 0.3.4  <span style="color: #a3a3a3;">(17ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rappdirs</span> 0.3.3  <span style="color: #a3a3a3;">(13ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">readr</span> 2.1.2  <span style="color: #a3a3a3;">(31ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rematch2</span> 2.1.2  <span style="color: #a3a3a3;">(10ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rex</span> 1.2.1  <span style="color: #a3a3a3;">(13ms)</span>                                                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rmarkdown</span> 2.16  <span style="color: #a3a3a3;">(65ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rprojroot</span> 2.0.3  <span style="color: #a3a3a3;">(13ms)</span>                                             
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">desc</span> 1.4.2                                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rstudioapi</span> 0.14  <span style="color: #a3a3a3;">(17ms)</span>                                             
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">sass</span> 0.4.2  <span style="color: #a3a3a3;">(36ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">scales</span> 1.2.1  <span style="color: #a3a3a3;">(89ms)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">stringr</span> 1.4.1  <span style="color: #a3a3a3;">(35ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">sys</span> 3.4  <span style="color: #a3a3a3;">(12ms)</span>                                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">testthat</span> 3.1.4  <span style="color: #a3a3a3;">(40ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">stringi</span> 1.7.8  <span style="color: #a3a3a3;">(230ms)</span>                                              
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tidyselect</span> 1.1.2  <span style="color: #a3a3a3;">(39ms)</span>                                            
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tinytex</span> 0.41  <span style="color: #a3a3a3;">(30ms)</span>                                                
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tidyr</span> 1.2.1                                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tzdb</span> 0.3.0  <span style="color: #a3a3a3;">(138ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">viridisLite</span> 0.4.1  <span style="color: #a3a3a3;">(41ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">viridis</span> 0.6.2  <span style="color: #a3a3a3;">(42ms)</span>                                               
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">waldo</span> 0.4.0  <span style="color: #a3a3a3;">(28ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">visNetwork</span> 2.1.0  <span style="color: #a3a3a3;">(98ms)</span>                                            
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">vroom</span> 1.5.7  <span style="color: #a3a3a3;">(89ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">withr</span> 2.5.0  <span style="color: #a3a3a3;">(82ms)</span>                                                 
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">xfun</span> 0.32  <span style="color: #a3a3a3;">(115ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">yaml</span> 2.3.5  <span style="color: #a3a3a3;">(51ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">desc</span> 1.4.2 <span style="color: #a3a3a3;">(1.5s)</span>                                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">desc</span> 1.4.2  <span style="color: #a3a3a3;">(15ms)</span>                                                  
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tidyr</span> 1.2.1 <span style="color: #a3a3a3;">(4.4s)</span>                                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tidyr</span> 1.2.1  <span style="color: #a3a3a3;">(19ms)</span>                                                 
#> <span style="color: #859900;">✔</span> 103 deps: kept 15, upd 2, added 86, dld 3 (2.23 MB) <span style="color: #b8b8b8;">[10.4s]</span>                   
</pre></div>
}}

}
}

\section{Repositories}{
\subsection{List current repositories}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 5 × 5</span>                                                           
#>   name          url                                        type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                                      <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cloud.r-project.org                cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> BioCsoft      https://bioconductor.org/packages/3.15/bi… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">3</span> BioCann       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">4</span> BioCexp       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">5</span> BioCworkflows https://bioconductor.org/packages/3.15/wo… bioc  4.2.1   3.15   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>                 
</pre></div>
}}

}

\subsection{Add custom repository}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::repo_add(rhub = 'https://r-hub.r-universe.dev')
pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 6 × 5</span>                                                           
#>   name          url                                        type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                                      <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cloud.r-project.org                cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> rhub          https://r-hub.r-universe.dev               cran… *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">3</span> BioCsoft      https://bioconductor.org/packages/3.15/bi… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">4</span> BioCann       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">5</span> BioCexp       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">6</span> BioCworkflows https://bioconductor.org/packages/3.15/wo… bioc  4.2.1   3.15   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>                 
</pre></div>
}}

}

\subsection{Remove custom repositories}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(repos = getOption("repos")["CRAN"])
pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 5 × 5</span>                                                           
#>   name          url                                        type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                                      <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cloud.r-project.org                cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> BioCsoft      https://bioconductor.org/packages/3.15/bi… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">3</span> BioCann       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">4</span> BioCexp       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">5</span> BioCworkflows https://bioconductor.org/packages/3.15/wo… bioc  4.2.1   3.15   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>                 
</pre></div>
}}


Keeps only CRAN and (by default) Bioconductor.
}

\subsection{Time travel using RSPM}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::repo_add(CRAN = "RSPM@2022-06-30")
pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 5 × 5</span>                                                           
#>   name          url                                        type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                                      <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://packagemanager.rstudio.com/all/11… cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> BioCsoft      https://bioconductor.org/packages/3.15/bi… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">3</span> BioCann       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">4</span> BioCexp       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">5</span> BioCworkflows https://bioconductor.org/packages/3.15/wo… bioc  4.2.1   3.15   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>                 
</pre></div>
}}

}

\subsection{Time travel using MRAN}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::repo_add(CRAN = "MRAN@2022-06-30")
pak::repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 5 × 5</span>                                                           
#>   name          url                                        type  r_ver…¹ bioc_…²
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                                      <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cran.microsoft.com/snapshot/2022-… cran  *       <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">2</span> BioCsoft      https://bioconductor.org/packages/3.15/bi… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">3</span> BioCann       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">4</span> BioCexp       https://bioconductor.org/packages/3.15/da… bioc  4.2.1   3.15   
#> <span style="color: #c2c2c2;">5</span> BioCworkflows https://bioconductor.org/packages/3.15/wo… bioc  4.2.1   3.15   
#> <span style="color: #999999;"># … with abbreviated variable names ¹​r_version, ²​bioc_version</span>                 
</pre></div>
}}

}
}

\section{Caches}{
\subsection{Inspect metadata cache}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::meta_list()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #859900;">✔</span> Updated metadata database: 4.51 MB in 8 files.                                
#> <span style="color: #2AA198;">ℹ</span> R 4.2 aarch64-apple-darwin20 packages are missing from Bioconductor           
#> <span style="color: #859900;">✔</span> Updating metadata database ... done                                           
#> <span style="color: #999999;"># A data frame: 41,614 × 32</span>                                                     
#>    package version depends sugge…¹ license imports linki…² archs enhan…³ os_type
#>    <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;"> 1</span> A3      1.0.0   R (&gt;= … random… GPL (&gt;… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 2</span> AATtoo… 0.0.1   R (&gt;= … <span style="color: #DC322F;">NA</span>      GPL-3   magrit… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 3</span> ABACUS  1.0.0   R (&gt;= … rmarkd… GPL-3   ggplot… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 4</span> ABC.RAP 0.9.0   R (&gt;= … knitr,… GPL-3   graphi… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 5</span> ABCana… 1.2.1   R (&gt;= … <span style="color: #DC322F;">NA</span>      GPL-3   plotrix <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 6</span> ABCopt… 0.15.0  <span style="color: #DC322F;">NA</span>      testth… MIT + … Rcpp, … Rcpp    ABCo… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 7</span> ABCp2   1.2     MASS    <span style="color: #DC322F;">NA</span>      GPL-2   <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 8</span> ABHgen… 1.0.1   <span style="color: #DC322F;">NA</span>      knitr,… GPL-3   ggplot… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 9</span> ABPS    0.3     <span style="color: #DC322F;">NA</span>      testth… GPL (&gt;… kernlab <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">10</span> ACA     1.1     R (&gt;= … <span style="color: #DC322F;">NA</span>      GPL     graphi… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>     
#> <span style="color: #999999;"># … with 41,604 more rows, 22 more variables: priority &lt;chr&gt;,</span>                   
#> <span style="color: #999999;">#   license_is_foss &lt;chr&gt;, license_restricts_use &lt;chr&gt;, repodir &lt;chr&gt;,</span>          
#> <span style="color: #999999;">#   rversion &lt;chr&gt;, platform &lt;chr&gt;, needscompilation &lt;chr&gt;, ref &lt;chr&gt;,</span>          
#> <span style="color: #999999;">#   type &lt;chr&gt;, direct &lt;lgl&gt;, status &lt;chr&gt;, target &lt;chr&gt;, mirror &lt;chr&gt;,</span>         
#> <span style="color: #999999;">#   sources &lt;list&gt;, filesize &lt;int&gt;, sha256 &lt;chr&gt;, sysreqs &lt;chr&gt;, built &lt;chr&gt;,</span>   
#> <span style="color: #999999;">#   published &lt;dttm&gt;, deps &lt;list&gt;, md5sum &lt;chr&gt;, path &lt;chr&gt;, and abbreviated</span>    
#> <span style="color: #999999;">#   variable names ¹​suggests, ²​linkingto, ³​enhances</span>                          
</pre></div>
}}

}

\subsection{Update metadata cache}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::meta_update()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #859900;">✔</span> Updated metadata database: 27.10 kB in 4 files.                               
#> <span style="color: #2AA198;">ℹ</span> R 4.2 aarch64-apple-darwin20 packages are missing from Bioconductor           
#> <span style="color: #859900;">✔</span> Updating metadata database ... done                                           
</pre></div>
}}

}

\subsection{Clean metadata cache}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::meta_clean(force = TRUE)
pak::meta_summary()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> $cachepath                                                                      
#> [1] "/Users/gaborcsardi/Library/Caches/org.R-project.R/R/pkgcache/_metadata"    
#>                                                                                 
#> $current_db                                                                     
#> [1] "/Users/gaborcsardi/Library/Caches/org.R-project.R/R/pkgcache/_metadata/pkgs
#> -9e6361fdc9.rds"                                                                
#>                                                                                 
#> $raw_files                                                                      
#> character(0)                                                                    
#>                                                                                 
#> $db_files                                                                       
#> character(0)                                                                    
#>                                                                                 
#> $size                                                                           
#> [1] 0                                                                           
#>                                                                                 
</pre></div>
}}

}

\subsection{Inspect package cache}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::cache_list()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 1,873 × 11</span>                                                      
#>    fullpath       path  package url   etag  sha256 version platf…¹ built vigne…²
#>    <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>          <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;"> 1</span> /Users/gaborc… src/… pak     file…  <span style="color: #DC322F;">NA</span>   4e451… 0.2.0.… source  <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 2</span> /Users/gaborc… src/… pak     <span style="color: #DC322F;">NA</span>     <span style="color: #DC322F;">NA</span>   <span style="color: #DC322F;">NA</span>     0.2.0.… aarch6… TRUE  FALSE  
#> <span style="color: #c2c2c2;"> 3</span> /Users/gaborc… bin/… cli     http… <span style="color: #999999;">"</span>\\"1… cbf6f… 3.1.1   aarch6… <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 4</span> /Users/gaborc… src/… R7      <span style="color: #DC322F;">NA</span>     <span style="color: #DC322F;">NA</span>   76af5… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>      FALSE <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 5</span> /Users/gaborc… src/… Annota… http… <span style="color: #999999;">"</span>\\"4… 9c18b… 1.18.0  source  <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 6</span> /Users/gaborc… bin/… GGally  http… <span style="color: #999999;">"</span>\\"1… a8ab8… 2.1.2   aarch6… <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 7</span> /Users/gaborc… src/… ensemb… http… <span style="color: #999999;">"</span>\\"3… 0913f… 2.18.3  source  <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 8</span> /Users/gaborc… src/… bioviz… http… <span style="color: #999999;">"</span>\\"2… 5faa6… 1.42.0  source  <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 9</span> /Users/gaborc… src/… Annota… http… <span style="color: #999999;">"</span>\\"4… 283e2… 1.56.2  source  <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;">10</span> /Users/gaborc… src/… rtrack… http… <span style="color: #999999;">"</span>\\"3… 0c5e4… 1.54.0  source  <span style="color: #DC322F;">NA</span>    <span style="color: #DC322F;">NA</span>     
#> <span style="color: #999999;"># … with 1,863 more rows, 1 more variable: rversion &lt;chr&gt;, and abbreviated</span>      
#> <span style="color: #999999;">#   variable names ¹​platform, ²​vignettes</span>                                      
</pre></div>
}}

}

\subsection{View a package cache summary}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::cache_summary()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> $cachepath                                                                      
#> [1] "/Users/gaborcsardi/Library/Caches/org.R-project.R/R/pkgcache/pkg"          
#>                                                                                 
#> $files                                                                          
#> [1] 1873                                                                        
#>                                                                                 
#> $size                                                                           
#> [1] 6711771702                                                                  
#>                                                                                 
</pre></div>
}}

}

\subsection{Clean package cache}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::cache_clean()
}\if{html}{\out{</div>}}
}
}

\section{Libraries}{
\subsection{List packages in a library}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::lib_status(Sys.getenv("R_LIBS_USER"))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 531 × 38</span>                                                        
#>    library   package title version depends repos…¹ license needs…² built remot…³
#>    <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>     <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;lgl&gt;</span>   <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>  
#> <span style="color: #c2c2c2;"> 1</span> /Users/g… abc     Tool… 2.2.1   R (&gt;= … CRAN    GPL (&gt;… FALSE   R 4.… standa…
#> <span style="color: #c2c2c2;"> 2</span> /Users/g… abc.da… Data… 1.0     R (&gt;= … CRAN    GPL (&gt;… FALSE   R 4.… standa…
#> <span style="color: #c2c2c2;"> 3</span> /Users/g… abind   Comb… 1.4-5   R (&gt;= … CRAN    LGPL (… FALSE   R 4.… standa…
#> <span style="color: #c2c2c2;"> 4</span> /Users/g… ape     Anal… 5.6-2   R (&gt;= … CRAN    GPL-2 … TRUE    R 4.… standa…
#> <span style="color: #c2c2c2;"> 5</span> /Users/g… archive Mult… 1.1.5   R (&gt;= … CRAN    MIT + … TRUE    R 4.… standa…
#> <span style="color: #c2c2c2;"> 6</span> /Users/g… arrow   Inte… 8.0.0   R (&gt;= … CRAN    Apache… TRUE    R 4.… standa…
#> <span style="color: #c2c2c2;"> 7</span> /Users/g… asciic… Crea… 2.1.0.… <span style="color: #DC322F;">NA</span>      <span style="color: #DC322F;">NA</span>      MIT + … <span style="color: #DC322F;">NA</span>      R 4.… <span style="color: #DC322F;">NA</span>     
#> <span style="color: #c2c2c2;"> 8</span> /Users/g… askpass Safe… 1.1     <span style="color: #DC322F;">NA</span>      CRAN    MIT + … TRUE    R 4.… standa…
#> <span style="color: #c2c2c2;"> 9</span> /Users/g… assert… Easy… 0.2.1   <span style="color: #DC322F;">NA</span>      CRAN    GPL-3   FALSE   R 4.… standa…
#> <span style="color: #c2c2c2;">10</span> /Users/g… async   Asyn… 0.0.0.… R (&gt;= … <span style="color: #DC322F;">NA</span>      MIT + … <span style="color: #DC322F;">NA</span>      R 4.… <span style="color: #DC322F;">NA</span>     
#> <span style="color: #999999;"># … with 521 more rows, 28 more variables: remotepkgref &lt;chr&gt;, remoteref &lt;chr&gt;,</span> 
#> <span style="color: #999999;">#   remoterepos &lt;chr&gt;, remotepkgplatform &lt;chr&gt;, remotesha &lt;chr&gt;, imports &lt;chr&gt;,</span> 
#> <span style="color: #999999;">#   suggests &lt;chr&gt;, linkingto &lt;chr&gt;, remotes &lt;chr&gt;, enhances &lt;chr&gt;,</span>             
#> <span style="color: #999999;">#   biocviews &lt;chr&gt;, remoteurl &lt;chr&gt;, priority &lt;chr&gt;, remotehost &lt;chr&gt;,</span>         
#> <span style="color: #999999;">#   remoterepo &lt;chr&gt;, remoteusername &lt;chr&gt;, remoteetag &lt;chr&gt;,</span>                   
#> <span style="color: #999999;">#   remotepackaged &lt;chr&gt;, md5sum &lt;chr&gt;, platform &lt;chr&gt;, sysreqs &lt;chr&gt;,</span>          
#> <span style="color: #999999;">#   ref &lt;chr&gt;, type &lt;chr&gt;, status &lt;chr&gt;, rversion &lt;chr&gt;, sources &lt;list&gt;, …</span>      
</pre></div>
}}


Pass the directory of the library as the argument.
}
}

