% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelineHelpers.R
\name{p2.generate.go}
\alias{p2.generate.go}
\title{Generate a GO environment for the organism specified}
\usage{
p2.generate.go(
  r,
  organism = NULL,
  go2all.egs = NULL,
  eg.alias2eg = NULL,
  min.env.length = 5
)
}
\arguments{
\item{r}{a 'Pagoda2' object}

\item{organism}{the organism (default=NULL). Currently 'hs' (human), 'mm' (mouse) and 'dr' (zebrafish) are supported.}

\item{go2all.egs}{mappings between a given GO identifier and all of the Entrez Gene identifiers 
annotated at that GO term or to one of its child nodes in the GO ontology (default=NULL)}

\item{eg.alias2eg}{mappings between common gene symbol identifiers and entrez gene identifiers (default=NULL)}

\item{min.env.length}{numeric Minimum environment length (default=5)}
}
\description{
Generate a GO environment for the organism specified
}
\examples{
\donttest{
cm <- p2data::sample_BM1
p2 <- basicP2proc(cm)
p2.generate.go(p2, organism='hs')
}

}
