% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{article_pageviews}
\alias{article_pageviews}
\title{Retrieve Pageview Data for an Article}
\usage{
article_pageviews(
  project = "en.wikipedia",
  article = "R (programming language)",
  platform = "all",
  user_type = "all",
  start = "2015100100",
  end = NULL,
  reformat = TRUE,
  granularity = "daily",
  ...
)
}
\arguments{
\item{project}{the name of the project, structured as \code{[language_code].[project]}
(see the default).}

\item{article}{the article(s) you want to retrieve data for. Ideally features underscores in the title
instead of spaces, but happily converts if you forget to do this.}

\item{platform}{The platform the pageviews came from; One or more of "all", "desktop", "mobile-web" and
"mobile-app". Set to "all" by default.}

\item{user_type}{the type of users. One or more of "all", "user", "spider" or "automated". "all" by default.}

\item{start}{the start \code{YYYYMMDDHH} of the range you want to cover. This can be
easily grabbed from R date/time objects using \code{\link{pageview_timestamps}}.}

\item{end}{the end \code{YYYYMMDDHH} of the range you want to cover. NULL by default, meaning
that it returns 1 day of data.}

\item{reformat}{Whether to reformat the results as a \code{\link{data.frame}} or not. TRUE by default.}

\item{granularity}{the granularity of data to return; "daily" or "monthly", depending on
whether pageview data should reflect trends in days or months.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
retrieves the pageview data for a particular article on a project, within
a provided time-range.
}
\examples{
# Basic example
r_pageviews <- article_pageviews()

# Modify the article
obama_pageviews <- article_pageviews(article = "Barack_Obama")

}
\seealso{
\code{\link{top_articles}} for the top articles per project in a given date range,
and \code{\link{project_pageviews}} for per-project pageviews.
}
