% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conflicts.R
\name{pacta_loanbook_conflicts}
\alias{pacta_loanbook_conflicts}
\title{Conflicts between the \code{{pacta.loanbook}} and other packages}
\usage{
pacta_loanbook_conflicts(only = NULL)
}
\arguments{
\item{only}{Set this to a character vector to restrict to conflicts only
with these packages.}
}
\value{
a \code{pacta_loanbook_conflicts} classed list which will print a list of
conflicts to the console in interactive sessions, or \code{NULL} if no conflicts
are found.
}
\description{
This function lists all the conflicts between packages in the
\code{{pacta.loanbook}} and other packages that you have loaded.
}
\details{
There are four conflicts that are deliberately ignored: \code{intersect},
\code{union}, \code{setequal}, and \code{setdiff} from dplyr. These functions
make the base equivalents generic, so shouldn't negatively affect any
existing code.
}
\examples{
pacta_loanbook_conflicts()
}
\seealso{
Other utility functions: 
\code{\link{pacta_loanbook_deps}()},
\code{\link{pacta_loanbook_logo}()},
\code{\link{pacta_loanbook_packages}()},
\code{\link{pacta_loanbook_sitrep}()},
\code{\link{pacta_loanbook_update}()}
}
\concept{utility functions}
