% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_install.R
\name{p_install}
\alias{p_install}
\alias{p_get}
\title{Installs & Loads Packages}
\usage{
p_install(package, character.only = FALSE, force = TRUE,
  path = getOption("download_path"), try.bioconductor = TRUE,
  update.bioconductor = FALSE, ...)

p_get(package, character.only = FALSE, force = TRUE,
  path = getOption("download_path"), try.bioconductor = TRUE,
  update.bioconductor = FALSE, ...)
}
\arguments{
\item{package}{Name of package(s).}

\item{character.only}{logical.  If \code{TRUE} \code{\dots} is treated a 
character string.}

\item{force}{logical. Should package be installed if it already exists on 
local system?}

\item{path}{The path to the directory that contains the package.  It is 
convenient to set \code{download_path} in .Rprofile options to the downloads 
directory.}

\item{try.bioconductor}{If \code{TRUE}, tries to install the package from 
Bioconductor if it is not found on CRAN using \pkg{BiocManager}.}

\item{update.bioconductor}{If \code{TRUE}, tries to update dependencies used
by \code{try.bioconductor}.}

\item{\ldots}{Additional parameters to pass to \code{install.packages}.}
}
\description{
Installs a package provided the package is a CRAN package.
}
\examples{
\dontrun{p_install(pacman)}
}
\seealso{
\code{\link[utils]{install.packages}}
}
\keyword{install}
\keyword{package}
