% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circleRepelLayout.R
\name{circleRepelLayout}
\alias{circleRepelLayout}
\title{Arranges circles by iterative pair-wise repulsion within a bounding rectangle}
\usage{
circleRepelLayout(x, xlim, ylim, xysizecols = c(1, 2, 3),
  sizetype = c("area", "radius"), maxiter = 1000, wrap = TRUE,
  weights = 1)
}
\arguments{
\item{x}{Either a vector of circle sizes (areas or radii) or a matrix or 
data frame with a column of sizes and, optionally, columns for initial
x-y coordinates of circle centres.}

\item{xlim}{The bounds in the X direction; either a vector for [xmin, xmax) 
or a single value interpreted as [0, xmax). Alternatively, omitting this 
argument or passing any of \code{NULL}, a vector of \code{NA} or an empty
vector will result in unbounded movement in the X direction.}

\item{ylim}{The bounds in the Y direction; either a vector for [ymin, ymax) 
or a single value interpreted as [0, ymax). Alternatively, omitting this 
argument or passing any of \code{NULL}, a vector of \code{NA} or an empty
vector will result in unbounded movement in the Y direction.}

\item{xysizecols}{The integer indices or names of the columns in \code{x} 
for the centre x-y coordinates and sizes of circles. This argument is
ignored if \code{x} is a vector.  If \code{x} is a matrix or data frame
but does not contain initial x-y coordinates, this can be indicated as
\code{xysizecols = c(NA, NA, 1)} for example.}

\item{sizetype}{The type of size values: either \code{"area"} or \code{"radius"}.
May be abbreviated.}

\item{maxiter}{The maximum number of iterations.}

\item{wrap}{Whether to treat the bounding rectangle as a toroid (default 
\code{TRUE}). When this is in effect, a circle leaving the bounds on one 
side re-enters on the opposite side.}

\item{weights}{An optional vector of numeric weights (0 to 1 inclusive) to 
apply to the distance each circle moves during pair-repulsion. A weight of 
0 prevents any movement. A weight of 1 gives the default movement distance.
A single value can be supplied for uniform weights. A vector with length 
less than the number of circles will be silently extended by repeating the 
final value. Any values outside the range [0, 1] will be clamped to 0 or 1.}
}
\value{
A list with components: \describe{ \item{layout}{A 3-column matrix or
  data frame (centre x, centre y, radius).} \item{niter}{Number of iterations
  performed.} }
}
\description{
This function takes a set of circles, defined by a data frame of initial 
centre positions and radii, and uses iterative pair-wise repulsion to try to 
find a non-overlapping arrangement where all circle centres lie inside a 
bounding rectangle. If no such arrangement can be found within the specified 
maximum number of iterations, the last attempt is returned.
}
\details{
The algorithm is adapted from a demo written in the Processing language by 
\href{http://www.cricketschirping.com/processing/CirclePacking1/CirclePacking1.pde}{Sean McCullough}.
Each circle in the input data is compared to those following it. If two 
circles overlap, they are moved apart such that the distance moved by each is
proportional to the radius of the other, loosely simulating inertia. So when 
a small circle is overlapped by a larger circle, the small circle moves 
furthest. This process is repeated until no more movement takes place 
(acceptable layout) or the maximum number of iterations is reached (layout 
failure).

To avoid edge effects, the bounding rectangle can be treated as a toroid by 
setting the \code{wrap} argument to \code{TRUE}. With this option, a circle 
moving outside the bounds re-enters at the opposite side.
}
