% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{check_values_states}
\alias{check_values_states}
\title{Check if the values of health states are provided}
\usage{
check_values_states(health_states)
}
\arguments{
\item{health_states}{list of health_state objects}
}
\value{
true or false
}
\description{
Check if the values of health states are provided
}
\details{
This is to check if the values are numeric during  the run time,
else to throw an error
}
\examples{
\donttest{
well <- health_state("well", cost = 0, utility = 1)
disabled <- health_state("disabled", cost = 100, utility = 1)
dead <- health_state("dead", cost = 0, utility = 0)
tmat <- rbind(c(1, 2, 3), c(NA, 4, 5), c(NA, NA, 6))
colnames(tmat) <- rownames(tmat) <- c("well", "disabled", "dead")
tm <- populate_transition_matrix(3, tmat, c(0.6, 0.2, 0.2, 0.6, 0.4, 1))
health_states <- combine_state(well, disabled, dead)
check_values_states(health_states)
}
}
