% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{PM.distanceFrom}
\alias{PM.distanceFrom}
\title{Calculate the distance between two Process Mining models}
\usage{
PM.distanceFrom(PM.obj, objToCheck, metric = "default")
}
\arguments{
\item{PM.obj}{the first Process Mining object}

\item{objToCheck}{the second Process Mining object}

\item{metric}{a string indicating the desired metric. At the moment only the default metric (is '\code{default}') is available}
}
\value{
a \code{list} containing the results of the distance and some ancillary information (some metrics could return a non-scalar value)
}
\description{
this function wraps the \code{<object>::distanceFrom() } method and calculates the 'distance' between an first Process Mining model object (passed with the parameter \code{aaObj}) and a second Process Mining model object (passed with the parameter \code{objToCheck}). This method allows to compute the distance according to many metrics. If not specified it uses the default metric.
}
\examples{
\dontrun{
# instantiate two dataLoaders
obj.LD.01<-LD.builder()
obj.LD.02<-LD.builder()

# load the two csv (for rectal and breast cancer)
LD.load.csv(loader.obj = obj.LD.01 ,nomeFile = "../csv/dati_retto.csv",
      IDName = "CODICE_SANITARIO_ADT",EVENTName = "CAT1")
LD.load.csv(loader.obj = obj.LD.02 ,nomeFile = "../csv/dati_mammella.csv",
      IDName = "CODICE_SANITARIO_ADT",EVENTName = "CAT1")

# create two first order markov model
obj.PM.rectum <-PM.builder(kindOfObject = "firstOrderMarkovModel")
obj.PM.breast <-PM.builder(kindOfObject = "firstOrderMarkovModel")

# and load the .csv 
PM.loadDataset(PM.obj = obj.PM.rectum,dataList = LD.getData(loader.obj = obj.LD.01))
PM.loadDataset(PM.obj = obj.PM.breast,dataList = LD.getData(loader.obj = obj.LD.02))

# train the two models
PM.trainModel(PM.obj = obj.PM.rectum)
PM.trainModel(PM.obj = obj.PM.breast)

# calculate the distance accortind to the default metric
PM.distanceFrom(PM.obj = obj.PM.breast,objToCheck = obj.PM.rectum)
}  
}

