% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{PM.builder}
\alias{PM.builder}
\title{Create an object from the classes \code{alphaAlgorithm} or \code{firstOrderMarkovModel}}
\usage{
PM.builder(kindOfObject, parameters.list = list())
}
\arguments{
\item{kindOfObject}{can be 'alphaAlgorithm' or 'firstOrderMarkovModel', according with the kind of object you want back}

\item{parameters.list}{some models allow to define some details (i.e.: thresholds for probabilities, etc.). In the current implementation 'alphaAlgorithm' does not allow to specify any parameters, while 'firstOrderMarkovModel' has two optional parameters:
\itemize{
\item \code{threshold } a number between 0 and 1 (default is 0). In the graph, arcs with a probability under the threshold will be removed
\item \code{considerAutoLoop } a boolean parameter (default is \code{TRUE}). If \code{FALSE} the arcs outcoming and incoming in the same node will be removed
}}
}
\value{
the wished object
}
\description{
This wrapping function instantiates a Process Mining model (\code{alphaAlgorithm} or \code{firstOrderMarkovModel} ) and provides an unique interface for both of them.
}
\examples{
\dontrun{
# Instantiate a'firstOrderMarkovModel' model
obj<- PM.builder(kindOfObject = "firstOrderMarkovModel")
}
}

