% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_integrand_edm.R
\name{max_integrand_edm}
\alias{max_integrand_edm}
\title{Maximize the integrand distance in measure criterion}
\usage{
max_integrand_edm(lower, upper, batchsize, alpha = 0.5, Thresh, model,
  verb = 1)
}
\arguments{
\item{lower}{a \eqn{d} dimensional vector containing the lower bounds for the optimization}

\item{upper}{a \eqn{d} dimensional vector containing the upper bounds for the optimization}

\item{batchsize}{number of simulations points to find}

\item{alpha}{value of Vorob'ev threshold}

\item{Thresh}{threshold value}

\item{model}{a km model}

\item{verb}{an integer to choose the level of verbosity}
}
\value{
A list containing \itemize{
        \item \code{par} a matrix \code{batchsize*d} containing the optimal points
        \item \code{value} a vector of length \code{batchsize} with the value of the criterion after each optimization
        \item \code{fcount} count of the number of criterion evaluations
}
}
\description{
Optimizes the integrand of the distance in measure criterion.
}
\references{
Azzimonti D. F., Bect J., Chevalier C. and Ginsbourger D. (2016). Quantifying uncertainties on excursion sets under a Gaussian random field prior. SIAM/ASA Journal on Uncertainty Quantification, 4(1):850–874.

Azzimonti, D. (2016). Contributions to Bayesian set estimation relying on random field priors. PhD thesis, University of Bern.
}
