% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WFSClient.R
\docType{class}
\name{WFSClient}
\alias{WFSClient}
\title{WFSClient}
\format{\code{\link{R6Class}} object.}
\usage{
WFSClient
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Feature Service.
}
\description{
WFSClient
}
\section{Methods}{

\describe{
 \item{\code{new(url, serviceVersion, user, pwd, logger)}}{
   This method is used to instantiate a WFSClient with the \code{url} of the
   OGC service. Authentication (\code{user}/\code{pwd}) is not yet supported and will
   be added with the support of service transactional modes. By default, the \code{logger}
   argument will be set to \code{NULL} (no logger). This argument accepts two possible 
   values: \code{INFO}: to print only \pkg{ows4R} logs, \code{DEBUG}: to print more verbose logs
 }
 \item{\code{getCapabilities()}}{
   Get service capabilities. Inherited from OWS Client
 }
 \item{\code{reloadCapabilities()}}{
   Reload service capabilities
 }
 \item{\code{describeFeatureType(typeName)}}{
   Get the description of a given featureType
 }
 \item{\code{getFeatures(typeName, ...)}}{
   Retrieves the features for a given feature type.
 }
}
}

\examples{
\donttest{
   #example based on a WFS endpoint responding at http://localhost:8080/geoserver/wfs
   wfs <- WFSClient$new("http://localhost:8080/geoserver/wfs", serviceVersion = "1.1.1")
   
   #get capabilities
   caps <- wfs$getCapabilities()
   
   #find feature type
   ft <- wfs$findFeatureTypeByName("mylayer", exact = TRUE)
   data <- ft$getFeatures()
   data_with_filter <- ft$getFeatures(cql_filter = "somefilter")
   
   #Advanced examples at https://github.com/eblondel/ows4R/wiki#wfs
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Feature}
\keyword{OGC}
\keyword{WFS}
