% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outsider.R
\name{verbosity_set}
\alias{verbosity_set}
\title{Set the verbosity of modules}
\usage{
verbosity_set(show_program = TRUE, show_docker = FALSE)
}
\arguments{
\item{show_program}{Show external program messages? Default TRUE.}

\item{show_docker}{Show docker messages? Default FALSE.}
}
\value{
data.frame
}
\description{
Control console messages of running outsider modules. Allow
either the external program messages to run, the Docker messages or both.
}
\details{
For more control see \code{\link[outsider.base]{log_set}}
}
\examples{
library(outsider)
# NOT RUN (too slow for automated testing)
\dontrun{
  if (is_outsider_ready()) {
    # simplest repo
    repo <- 'dombennett/om..hello.world'
    # install
    module_install(repo = repo, force = TRUE, update = 'never')
    # is module_installed?
    (is_module_installed(repo = repo))
    # uninstall
    module_uninstall(repo)
  }
}
}
