% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_ensemble.R
\name{greedy_ensemble}
\alias{greedy_ensemble}
\title{Computes an ensemble score using the greedy algorithm proposed by Schubert et al (2012)}
\usage{
greedy_ensemble(X, kk = 5)
}
\arguments{
\item{X}{The input data containing the outlier scores in a dataframe, matrix or tibble format. Rows contain observations and columns contain outlier detection methods.}

\item{kk}{The number of estimated outliers.}
}
\value{
A list with the components:
\item{\code{scores}}{The ensemble scores.}
\item{\code{methods}}{The methods that are chosen for the ensemble. }
\item{\code{chosen}}{The chosen subset of original anomaly scores.}
}
\description{
This function computes an ensemble score using the greedy algorithm in the paper titled Evaluation of Outlier Rankings and Outlier Scores by Schubert et al (2012) <doi:10.1137/1.9781611972825.90>. The greedy ensemble is detailed in  Section 4.3.
}
\examples{
set.seed(123)
X <- data.frame(x1 = rnorm(200), x2 = rnorm(200))
X[199, ] <- c(4, 4)
X[200, ] <- c(-3, 5)
y1 <- DDoutlier::KNN_AGG(X)
y2 <- DDoutlier::LOF(X)
y3 <- DDoutlier::COF(X)
y4 <- DDoutlier::INFLO(X)
y5 <- DDoutlier::KDEOS(X)
y6 <- DDoutlier::LDF(X)
y7 <- DDoutlier::LDOF(X)
Y <- cbind.data.frame(y1, y2, y3, y4, y5, y6, y7)
ens <- greedy_ensemble(Y, kk=5)
ens$scores

}
