% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R, R/brown.R, R/hansen.R
\docType{methods}
\name{update}
\alias{update}
\alias{update,browntree-method}
\alias{update,hansentree-method}
\alias{update-hansentree,}
\title{Update and refit a model.}
\usage{
\S4method{update}{browntree}(object, data, ...)

\S4method{update}{hansentree}(object, data, regimes, sqrt.alpha, sigma, ...)
}
\arguments{
\item{object}{fitted model object.}

\item{data}{data that replace those used in the original fit.}

\item{...}{Additional arguments replace the corresponding arguments in the original call.}

\item{regimes}{A vector of codes, one for each node in the tree, specifying the selective regimes hypothesized to have been operative.
Corresponding to each node, enter the code of the regime hypothesized for the branch segment terminating in that node.
For the root node, because it has no branch segment terminating on it, the regime specification is irrelevant.
If there are \code{nchar} quantitative characters, then one can specify a single set of \code{regimes} for all characters or a list of \code{nchar} regime specifications, one for each character.}

\item{sqrt.alpha}{These are used to initialize the optimization algorithm.
The selection strength matrix \eqn{\alpha}{alpha} and the random drift variance-covariance matrix \eqn{\sigma^2}{sigma^2} are parameterized by their matrix square roots.
Specifically, these initial guesses are each packed into lower-triangular matrices (column by column).
The product of this matrix with its transpose is the \eqn{\alpha}{alpha} or \eqn{\sigma^2}{sigma^2} matrix.
See Details for more information.}

\item{sigma}{These are used to initialize the optimization algorithm.
The selection strength matrix \eqn{\alpha}{alpha} and the random drift variance-covariance matrix \eqn{\sigma^2}{sigma^2} are parameterized by their matrix square roots.
Specifically, these initial guesses are each packed into lower-triangular matrices (column by column).
The product of this matrix with its transpose is the \eqn{\alpha}{alpha} or \eqn{\sigma^2}{sigma^2} matrix.
See Details for more information.}
}
\value{


\code{update} returns a new fitted-model object of the same class as  \code{object}.
}
\description{
\code{update} will update a model and re-fit.
This allows one to change the data and/or parameters.
}
\seealso{
Other methods: 
\code{\link{bootstrap}()},
\code{\link{coef}()},
\code{\link{logLik}},
\code{\link{plot}()},
\code{\link{print}()},
\code{\link{simulate}()},
\code{\link{summary}()}
}
\concept{methods}
