% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerical.R
\name{PlotDist}
\alias{PlotDist}
\title{Side-by-side box plots, for a numerical variable,  grouped by \code{dateGpBp}}
\usage{
PlotDist(dataFl, myVar, dateGpBp, weightNm = NULL, skewOpt = NULL)
}
\arguments{
\item{dataFl}{A \code{data.table} of data; must be the output of the
\code{\link{PrepData}} function.}

\item{myVar}{The name of the variable to be plotted}

\item{dateGpBp}{Name of variable the boxplots should be grouped by. Same
options as \code{dateGp}. If \code{NULL}, then \code{dateGp} will be used.}

\item{weightNm}{Name of the variable containing row weights, or \code{NULL} for 
no weights (all rows receiving weight 1).}

\item{skewOpt}{Either a numeric constant or \code{NULL}. Default is 
\code{NULL} (no transformation). If numeric, say 5, then all box plots of
a variable whose skewness exceeds 5 will be on a log10 scale if possible.
Negative input of \code{skewOpt} will be converted to 3.}
}
\value{
A \code{ggplot2} object with a box plot of \code{myVar} grouped by 
  \code{dateGpBp}
}
\description{
For a variable is all positive (no zeros) and has larger than 50 all distinct
values, if it is highly skewed, then all box plots can be plotted under the 
log base 10 transformation. See the argument \code{skewOpt} for details.
}
\section{License}{

Copyright 2017 Capital One Services, LLC Licensed under the Apache License,
Version 2.0 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the  License at
http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
or agreed to in writing, software distributed under the License is 
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
KIND, either express or implied. See the License for the specific language 
governing permissions and limitations under the License.
}

\examples{
data(bankData)
bankData <- PrepData(bankData, dateNm = "date", dateGp = "months", 
                     dateGpBp = "quarters")
PlotDist(dataFl = bankData, myVar = "balance", dateGpBp = "quarters")
## The following attempt to log transform will fail due to negative values,
## and the untransformed version will be returned
PlotDist(dataFl = bankData, myVar = "balance", dateGpBp = "quarters", 
         skewOpt = 3)
## This attempt should succeed, as the skew exceeds 3 and there are no 
## negative values
PlotDist(dataFl = bankData, myVar = "duration", dateGpBp = "quarters",
         skewOpt = 3)
}
