% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studiesAndLeadVariantsForGeneByL2G.R
\name{studiesAndLeadVariantsForGeneByL2G}
\alias{studiesAndLeadVariantsForGeneByL2G}
\title{Retrieve "locus-to-gene" (L2G) model summary data for a gene.}
\usage{
studiesAndLeadVariantsForGeneByL2G(gene, l2g = NA, pvalue = NA, vtype = NULL)
}
\arguments{
\item{gene}{Character: Gene ENSEMBL ID (e.g. ENSG00000169174) or gene symbol (e.g. PCSK9). This argument can take a list of genes too.}

\item{l2g}{Numeric: Locus-to-gene (L2G) cutoff score. (Default: NA)}

\item{pvalue}{Character: P-value cutoff. (Default: NA)}

\item{vtype}{Character: Most severe consequence to filter the variant types, including "intergenic_variant",
"upstream_gene_variant", "intron_variant", "missense_variant", "5_prime_UTR_variant",
"non_coding_transcript_exon_variant", "splice_region_variant". (Default: NULL)}
}
\value{
Returns a data frame containing the input gene ID and its data for the L2G model. The table consists of the following columns:
\itemize{
  \item{\code{yProbaModel}:} \emph{Numeric}. L2G score.
  \item{\code{yProbaDistance}:} \emph{Numeric}. Distance.
  \item{\code{yProbaInteraction}:} \emph{Numeric}. Chromatin interaction.
  \item{\code{yProbaMolecularQTL}:} \emph{Numeric}. Molecular QTL.
  \item{\code{yProbaPathogenicity}:} \emph{Numeric}. Pathogenicity.
  \item{\code{pval}:} \emph{Numeric}. P-value.
  \item{\code{beta.direction}:} \emph{Character}. Beta direction.
  \item{\code{beta.betaCI}:} \emph{Numeric}. Beta confidence interval.
  \item{\code{beta.betaCILower}:} \emph{Numeric}. Lower bound of the beta confidence interval.
  \item{\code{beta.betaCIUpper}:} \emph{Numeric}. Upper bound of the beta confidence interval.
  \item{\code{odds.oddsCI}:} \emph{Numeric}. Odds ratio confidence interval.
  \item{\code{odds.oddsCILower}:} \emph{Numeric}. Lower bound of the odds ratio confidence interval.
  \item{\code{odds.oddsCIUpper}:} \emph{Numeric}. Upper bound of the odds ratio confidence interval.
  \item{\code{study.studyId}:} \emph{Character}. Study ID.
  \item{\code{study.traitReported}:} \emph{Character}. Reported trait.
  \item{\code{study.traitCategory}:} \emph{Character}. Trait category.
  \item{\code{study.pubDate}:} \emph{Character}. Publication date.
  \item{\code{study.pubTitle}:} \emph{Character}. Publication title.
  \item{\code{study.pubAuthor}:} \emph{Character}. Publication author.
  \item{\code{study.pubJournal}:} \emph{Character}. Publication journal.
  \item{\code{study.pmid}:} \emph{Character}. PubMed ID.
  \item{\code{study.hasSumstats}:} \emph{Logical}. Indicates if the study has summary statistics.
  \item{\code{study.nCases}:} \emph{Integer}. Number of cases in the study.
  \item{\code{study.numAssocLoci}:} \emph{Integer}. Number of associated loci.
  \item{\code{study.nTotal}:} \emph{Integer}. Total number of samples in the study.
  \item{\code{study.traitEfos}:} \emph{Character}. Trait EFOs.
  \item{\code{variant.id}:} \emph{Character}. Variant ID.
  \item{\code{variant.rsId}:} \emph{Character}. Variant rsID.
  \item{\code{variant.chromosome}:} \emph{Character}. Variant chromosome.
  \item{\code{variant.position}:} \emph{Integer}. Variant position.
  \item{\code{variant.refAllele}:} \emph{Character}. Variant reference allele.
  \item{\code{variant.altAllele}:} \emph{Character}. Variant alternate allele.
  \item{\code{variant.nearestCodingGeneDistance}:} \emph{Integer}. Distance to the nearest coding gene.
  \item{\code{variant.nearestGeneDistance}:} \emph{Integer}. Distance to the nearest gene.
  \item{\code{variant.mostSevereConsequence}:} \emph{Character}. Most severe consequence.
  \item{\code{variant.nearestGene.id}:} \emph{Character}. Nearest gene ID.
  \item{\code{variant.nearestCodingGene.id}:} \emph{Character}. Nearest coding gene ID.
  \item{\code{ensembl_id}:} \emph{Character}. Ensembl ID.
  \item{\code{gene_symbol}:} \emph{Character}. Gene symbol.
}
}
\description{
The "locus-to-gene" (L2G) model derives features to prioritize likely causal genes at each GWAS
locus based on genetic and functional genomics features. The main categories of predictive features are:
\itemize{
\item Distance: Distance from credible set variants to the gene.
\item Molecular QTL colocalization: Colocalization with molecular QTLs.
\item Chromatin interaction: Interactions, such as promoter-capture Hi-C.
\item Variant pathogenicity: Pathogenicity scores from VEP (Variant Effect Predictor).
}
}
\details{
The function also provides additional filtering parameters to narrow the results based following parameters (see below)
}
\examples{
\dontrun{
result <- studiesAndLeadVariantsForGeneByL2G(genes = c("ENSG00000163946",
     "ENSG00000169174", "ENSG00000143001"), l2g = 0.7)
result <- studiesAndLeadVariantsForGeneByL2G(genes = "ENSG00000169174",
     l2g = 0.6, pvalue = 1e-8, vtype = c("intergenic_variant", "intron_variant"))
result <- studiesAndLeadVariantsForGeneByL2G(genes = "TMEM61")
}
}
