% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enum.R
\name{enumHasKey}
\alias{enumHasKey}
\title{Check if an enum has a certain key.}
\usage{
enumHasKey(key, enum)
}
\arguments{
\item{key}{Key to check for.}

\item{enum}{Enum where to look for the \code{key}.}
}
\value{
\code{TRUE} if a key-value pair for \code{key} exists, \code{FALSE} otherwise.
}
\description{
Check if an enum has a certain key.
}
\examples{
Symbol <- enum(c(Diamond = 1, Triangle = 2, Circle = 2))
enumHasKey("Diamond", Symbol)
enumHasKey("Square", Symbol)

}
\seealso{
Other enumeration-helpers: 
\code{\link{enumGetKey}()},
\code{\link{enumGetValue}()},
\code{\link{enumKeys}()},
\code{\link{enumPut}()},
\code{\link{enumRemove}()},
\code{\link{enumValues}()},
\code{\link{enum}()}
}
\concept{enumeration-helpers}
