% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enum.R
\name{enumGetValue}
\alias{enumGetValue}
\title{Get enum values}
\usage{
enumGetValue(enum, key)
}
\arguments{
\item{enum}{The \code{enum} that contains the key-value pair.}

\item{key}{The \code{key} under which the value is stored.}
}
\value{
Value that is assigned to \code{key}.
}
\description{
Return the value that is stored under the given key. If the key is not
present, an error is thrown.
}
\examples{
Symbol <- enum(c(Diamond = 1, Triangle = 2, Circle = 2))
enumGetValue(Symbol, "Diamond")
}
\seealso{
Other enumeration-helpers: 
\code{\link{enumGetKey}()},
\code{\link{enumHasKey}()},
\code{\link{enumKeys}()},
\code{\link{enumPut}()},
\code{\link{enumRemove}()},
\code{\link{enumValues}()},
\code{\link{enum}()}
}
\concept{enumeration-helpers}
