% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/osmose-main.R
\name{osmose2R}
\alias{osmose2R}
\alias{read_osmose}
\title{Read OSMOSE outputs into an R object}
\usage{
osmose2R(path = NULL, version = "v3r2", species.names = NULL, ...)

read_osmose(
  path = NULL,
  input = NULL,
  version = "3.3.3",
  species.names = NULL,
  absolute = TRUE,
  ...
)
}
\arguments{
\item{path}{Path to the directory containing OSMOSE outputs.}

\item{version}{OSMOSE version used to run the model.}

\item{species.names}{Display names for species, overwrite the species names
provided to the OSMOSE model. Used for plots and summaries.}

\item{...}{Additional arguments.}

\item{input}{Path to a main OSMOSE configuration file.}

\item{absolute}{Whether the path is absolute (\code{TRUE}) or relative 
(\code{FALSE}). Only used if input is not NULL.}
}
\description{
This function create object of class \code{osmose} with the 
outputs from OSMOSE in the \code{path} folder.
}
\details{
\code{read_osmose} will return a list of fields with the information
of whether an OSMOSE running or the configuration that is going to be used in 
a running. Output class will depend on the read info: If \code{path} is 
specified, output class will be \code{osmose}; otherwise, if ONLY \code{input}
is given, the class will be \code{osmose.config}. If both are specified, the 
\code{osmose} class output will content inside a field (\code{config}) of 
class \code{osmose.config}.

Individual elements can be extracted using the \link{get_var} function.
}
\examples{
# Read outputs generated by demo (check osmose_demo function)
outdir = cacheManager("outputs")
read_osmose(path = outdir)
  
}
\author{
Ricardo Oliveros-Ramos, Laure Velez
}
