% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose-main.R
\name{osmose_demo}
\alias{osmose_demo}
\title{Generates required OSMOSE configuration files to run a demo.}
\usage{
osmose_demo(path = NULL, config = "gog")
}
\arguments{
\item{path}{Path where to put the Osmose configuration file.}

\item{config}{Reference configuration to run ("gog").}
}
\value{
A list containing the configuration file to use (config_file) for running the code
and the output directory to use when reading data.
}
\description{
Thins function
}
\note{
So far, only one configuration is propose ("gog")
}
\examples{
\dontrun{
rm(list=ls())

library("osmose")

# Copy configuration files into the proper directory
demo = osmose_demo(path="../", config="gog")

# run the osmose model
run_osmose(demo$config_file, parameters=NULL, output=NULL, version="3.3.3", 
          options=NULL, verbose=TRUE, clean=TRUE)

# reads output data
data = read_osmose(demo$output_dir)

# summarize output data
summary(data)

# plot output data
plot(data)
}
}
