% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{oe_download}
\alias{oe_download}
\title{Download a file given a url}
\usage{
oe_download(
  file_url,
  provider = NULL,
  file_basename = basename(file_url),
  download_directory = oe_download_directory(),
  file_size = NA,
  force_download = FALSE,
  max_file_size = 5e+08,
  quiet = FALSE
)
}
\arguments{
\item{file_url}{A URL pointing to a \code{.osm.pbf} file that should be
downloaded.}

\item{provider}{Which provider stores the file? If \code{NULL} (the default), it
may be inferred from the URL, but it must be specified for non-standard
cases. See details and examples.}

\item{file_basename}{The basename of the file. The default behaviour is to
auto-generate it from the URL using \code{basename()}.}

\item{download_directory}{Where to download the file containing the OSM data?
By default this is equal to \code{\link[=oe_download_directory]{oe_download_directory()}}, which is equal to
\code{\link[=tempdir]{tempdir()}} and it changes each time you restart R. You can set a
persistent \code{download_directory} by adding the following to your \code{.Renviron}
file (e.g. with \code{edit_r_environ} function in \code{usethis} package):
\verb{OSMEXT_DOWNLOAD_DIRECTORY=/path/to/osm/data}.}

\item{file_size}{How big is the file? Optional. \code{NA} by default. If it's
bigger than \code{max_file_size} and the function is run in interactive mode,
then an interactive menu is displayed, asking for permission for
downloading the file.}

\item{force_download}{Should the \code{.osm.pbf} file be updated if it has already
been downloaded? \code{FALSE} by default. This parameter is used to update old
\code{.osm.pbf} files.}

\item{max_file_size}{The maximum file size to download without asking in
interactive mode. Default: \code{5e+8}, half a gigabyte.}

\item{quiet}{Boolean. If \code{FALSE}, the function prints informative messages.
Starting from \code{sf} version
\href{https://r-spatial.github.io/sf/news/index.html#version-0-9-6-2020-09-13}{0.9.6},
if \code{quiet} is equal to \code{FALSE}, then vectortranslate operations will
display a progress bar.}
}
\value{
A character string representing the file's path.
}
\description{
This function is used to download a file given a URL. It focuses on OSM
extracts with \code{.osm.pbf} format stored by one of the providers implemented in
the package. The URL is specified through the parameter \code{file_url}.
}
\details{
This function runs several checks before actually downloading a new
file to avoid overloading the OSM providers. The first step is the
definition of the file's path associated to the input \code{file_url}. The path
is created by pasting together the \code{download_directory}, the name of chosen
provider (which may be inferred from the URL) and the \code{basename()} of the
URL. For example, if \code{file_url} is equal to
\code{"https://download.geofabrik.de/europe/italy-latest.osm.pbf"}, and
\code{download_directory = "/tmp"}, then the path is built as
\code{"/tmp/geofabrik_italy-latest.osm.pbf"}. Thereafter, the function checks
the existence of that file and, if it founds it, then it returns the path.
The parameter \code{force_download} is used to modify this behaviour. If there
is no file associated with the new path, then the function downloads a new
file using \code{\link[=download.file]{download.file()}} with \code{mode = "wb"}, and, again, it returns the
path.
}
\examples{
its_match = oe_match("ITS Leeds", quiet = TRUE)
oe_download(
  file_url = its_match$url,
  file_size = its_match$file_size,
  provider = "test",
  download_directory = tempdir()
)
\dontrun{
  iow_url = oe_match("Isle of Wight")
  oe_download(
    file_url = iow_url$url,
    file_size = iow_url$file_size,
    download_directory = tempdir()
  )
  Sucre_url = oe_match("Sucre", provider = "bbbike")
  oe_download(
    file_url = Sucre_url$url,
    file_size = Sucre_url$file_size,
    download_directory = tempdir()
  )}
# Remove .pbf and .gpkg files in tempdir
# (since they may interact with other examples)
file.remove(list.files(path = tempdir(), pattern = "(pbf|gpkg)", full.names = TRUE))
}
