% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_elements.R
\name{osm_create_object}
\alias{osm_create_object}
\title{Create an OSM object}
\usage{
osm_create_object(x, changeset_id)
}
\arguments{
\item{x}{The new object data. Can be the path to an xml file, a \link[xml2:oldclass]{xml2::xml_document} or a data.frame inheriting
or following the structure of an \code{osmapi_objects} object.}

\item{changeset_id}{The ID of an open changeset where to create the object. If missing, \code{x} should define the
changeset ID, otherwise it will be overwritten with \code{changeset_id}. Ignored if \code{x} is a path.}
}
\value{
The ID of the newly created OSM object.
}
\description{
Creates a new element in an open changeset as specified.
}
\details{
If \code{x} is a data.frame, the columns \code{type}, \code{changeset}, \code{tags} must be present + column \code{members} for ways and
relations + \code{lat} and \code{lon} for nodes. For the xml format, see the
\href{https://wiki.openstreetmap.org/wiki/API_v0.6#Create:_PUT_/api/0.6/\%5Bnode\%7Cway\%7Crelation\%5D/create}{OSM wiki}.

If multiple elements are provided only the first is created. The rest is discarded.
}
\note{
\itemize{
\item This updates the bounding box of the changeset.
\item The \code{role} attribute for relations is optional. An empty string is the default.
\item To avoid performance issues when uploading multiple objects, the use of the \code{\link[=osm_diff_upload_changeset]{osm_diff_upload_changeset()}} is highly
recommended.
\item The version of the created object will be 1.
}
}
\examples{
vignette("how_to_edit_osm", package = "osmapiR")
}
\seealso{
Other edit OSM objects' functions: 
\code{\link{osm_delete_object}()},
\code{\link{osm_update_object}()}
}
\concept{edit OSM objects' functions}
