% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pixdim.R
\docType{methods}
\name{pixdim-methods}
\alias{pixdim}
\alias{pixdim,anlz-method}
\alias{pixdim,nifti-method}
\alias{pixdim-methods}
\alias{pixdim-methods,}
\alias{pixdim<-}
\alias{pixdim<-,anlz-method}
\alias{pixdim<-,nifti-method}
\title{Extract Image Attribute \code{pixdim}}
\usage{
pixdim(object)

\S4method{pixdim}{nifti}(object)

\S4method{pixdim}{anlz}(object)

pixdim(object) <- value

\S4method{pixdim}{nifti}(object) <- value

\S4method{pixdim}{anlz}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{pixdim} field.}
}
\description{
Methods that act on the \code{pixdim} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
\dontrun{
url <- "http://nifti.nimh.nih.gov/nifti-1/data/avg152T1_LR_nifti.nii.gz"
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
"mniLR.nii.gz")
download.file(url, urlfile, quiet=TRUE)
}
urlfile <- file.path(system.file("nifti", package="oro.nifti"),
                     "mniLR.nii.gz")
mniLR <- readNIfTI(urlfile)
pixdim(mniLR)
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
ANALYZE 7.5\cr
\url{https://rportal.mayo.edu/bir/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}

