% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qoffset_y.R, R/zzz_niftiImage.R
\docType{methods}
\name{qoffset_y-methods}
\alias{qoffset_y-methods}
\alias{qoffset_y-methods,}
\alias{qoffset_y}
\alias{qoffset_y,nifti-method}
\alias{qoffset_y<-}
\alias{qoffset_y<-,nifti-method}
\alias{qoffset.y}
\alias{qoffset.y,nifti-method}
\alias{qoffset.y<-}
\alias{qoffset.y<-,nifti-method}
\alias{qoffset_y,niftiImage-method}
\alias{qoffset_y<-,niftiImage-method}
\title{Extract Image Attribute \code{qoffset_y}}
\usage{
qoffset_y(object)

\S4method{qoffset_y}{nifti}(object)

qoffset_y(object) <- value

\S4method{qoffset_y}{nifti}(object) <- value

qoffset.y(object)

\S4method{qoffset.y}{nifti}(object)

qoffset.y(object) <- value

\S4method{qoffset.y}{nifti}(object) <- value

\S4method{qoffset_y}{niftiImage}(object)

\S4method{qoffset_y}{niftiImage}(object) <- value
}
\arguments{
\item{object}{is an object of class \code{nifti} or \code{anlz}.}

\item{value}{is the value to assign to the \code{qoffset_y} field.}
}
\description{
Methods that act on the \code{qoffset_y} field in the
NIfTI/ANALYZE header.
}
\details{
See documentation on the ANALYZE and/or NIfTI data standards for
more details.
}
\examples{
file = system.file("extdata", "example.nii.gz", package = "RNifti")
img = RNifti::readNifti(file)
qoffset_y(img)
qoffset_y(img) = 10
stopifnot(qoffset_y(img) == 10)
}
\references{
ANALYZE 7.5\cr
\url{http://eeg.sourceforge.net/ANALYZE75.pdf}\cr
NIfTI-1\cr
\url{http://nifti.nimh.nih.gov/}
}
\author{
John Muschelli \email{muschellij2@gmail.com},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
